package dev.felnull.otyacraftengine.client.renderer.texture;

import com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.fnjl.util.FNImageUtil;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;
import net.minecraft.class_3532;

public final class DynamicGifTexture extends class_1043 implements class_1061 {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    private DynamicGifTexture(long duration, ImageFrame... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    @Override
    public void method_4622() {
        int ct = Math.toIntExact(getFrameByTime(System.currentTimeMillis() % duration));
        if (ct != last) {
            this.field_5200 = frames[ct].image();
            method_4524();
            last = ct;
        }
    }

    private int getFrameByTime(long time) {
        return class_3532.method_15360(0, frames.length, v -> time <= frames[v].timestamp());
    }

    @Override
    public void close() {
        super.close();
        if (frames != null) {
            for (ImageFrame image : frames) {
                if (image != null)
                    image.image().close();
            }
        }
    }

    @NotNull
    public static DynamicGifTexture create(@NotNull GifDecoder decoder, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        ImageFrame[] frames = new ImageFrame[decoder.getFrameCount()];
        if (progress != null)
            progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), 0));
        long duration = 0;
        for (int i = 0; i < decoder.getFrameCount(); i++) {
            if (progress != null)
                progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), i + 1));
            var img = decoder.getFrame(i);
            long delay = decoder.getDelay(i);
            duration += delay;
            try (var stream = FNImageUtil.toInputStream(img, "png")) {
                frames[i] = new ImageFrame(class_1011.method_4309(stream), duration);
            }
        }
        return new DynamicGifTexture(duration, frames);
    }

    private static record ImageFrame(class_1011 image, long timestamp) {
    }
}
