package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.util.OEDataGenUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class DirectCopyProviderWrapper extends InputBaseProviderWrapper {
    public DirectCopyProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, target, kind, crossDataGeneratorAccess);
    }

    public DirectCopyProviderWrapper(class_7784 packOutput, class_7784.class_7490 target, String modId, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, target, modId, kind, crossDataGeneratorAccess);
    }

    @Override
    protected @Nullable CompletableFuture<?> runTask(class_7403 cachedOutput, Path inputRoot, Path target) {
        return CompletableFuture.runAsync(() -> {
            var locEx = toResourceLocationAndExtension(inputRoot, target);
            try (InputStream stream = new FileInputStream(target.toFile()); InputStream bufStream = new BufferedInputStream(stream)) {
                OEDataGenUtils.save(cachedOutput, bufStream, pathProvider.method_44108(locEx.getKey(), locEx.getValue()));
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349());
    }

    @Override
    protected boolean isTarget(Path rootPath, Path targetPath) {
        return true;
    }

    @Override
    public String getName() {
        return "Input copy";
    }
}
