package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2096;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_6862;
import net.minecraft.class_7784;

public abstract class RecipeProviderWrapper extends DataProviderWrapper<class_2446> {
    private final class_2446 recipeProvider;

    public RecipeProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.recipeProvider = crossDataGeneratorAccess.createRecipeProvider(packOutput, this);
    }

    @Override
    public class_2446 getProvider() {
        return this.recipeProvider;
    }

    public abstract void generateRecipe(Consumer<class_2444> exporter, RecipeProviderAccess providerAccess);

    public static interface RecipeProviderAccess {
        class_2066.class_2068 has(class_2096.class_2100 ints, class_1935 itemLike);

        class_2066.class_2068 has(class_1935 itemLike);

        class_2066.class_2068 has(class_6862<class_1792> tagKey);

        String getHasName(class_1935 itemLike);

        String getItemName(class_1935 itemLike);
    }
}
