package dev.felnull.otyacraftengine.fabric.tag;

import com.google.common.base.Suppliers;
import dev.felnull.otyacraftengine.data.provider.IntrinsicHolderTagsProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import net.fabricmc.fabric.impl.tag.convention.TagRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class OEFabricItemTags {
    public static final Supplier<ManualTagHolder<class_1792>> IRON_NUGGETS = bind("iron_nuggets", tp -> tp.add(class_1802.field_8675));
    public static final Supplier<ManualTagHolder<class_1792>> ENDER_PEARLS = bind("ender_pearls", tp -> tp.add(class_1802.field_8634));
    public static final Supplier<ManualTagHolder<class_1792>> STONE = bind("stone", tp -> {
        tp.add(class_1802.field_20391, class_1802.field_20407, class_1802.field_20401, class_1802.field_20394, class_1802.field_28866);
        tp.add(class_1802.field_20411, class_1802.field_20403, class_1802.field_20397, class_1802.field_28871);
    });
    public static final Supplier<ManualTagHolder<class_1792>> REDSTONE_BLOCKS = bind("redstone_blocks", tp -> tp.add(class_1802.field_8793));
    public static final Supplier<ManualTagHolder<class_1792>> IRON_BLOCKS = bind("iron_blocks", tp -> tp.add(class_1802.field_8773));
    public static final Supplier<class_6862<class_1792>> BOOKS = bind("books");
    public static final Supplier<ManualTagHolder<class_1792>> RAW_MEATS = bind("raw_meats", tp -> tp.add(class_1802.field_8046, class_1802.field_8389, class_1802.field_8726, class_1802.field_8748, class_1802.field_8504).addOptionalTag(cLoc("raw_meat")));
    public static final Supplier<ManualTagHolder<class_1792>> COOKED_MEATS = bind("cooked_meats", tp -> tp.add(class_1802.field_8176, class_1802.field_8261, class_1802.field_8544, class_1802.field_8347, class_1802.field_8752).addOptionalTag(cLoc("cooked_meat")));
    public static final Supplier<ManualTagHolder<class_1792>> RAW_FISHES = bind("raw_fishes", tp -> tp.add(class_1802.field_8429, class_1802.field_8209, class_1802.field_8846, class_1802.field_8323).addOptionalTag(cLoc("raw_fish")));
    public static final Supplier<ManualTagHolder<class_1792>> COOKED_FISHES = bind("cooked_fishes", tp -> tp.add(class_1802.field_8373, class_1802.field_8509).addOptionalTag(cLoc("cooked_fish")));
    public static final Supplier<ManualTagHolder<class_1792>> WHEAT_BREADS = bind("wheat_breads", tp -> tp.add(class_1802.field_8229).addOptionalTag(cLoc("bread/wheat")));
    public static final Supplier<ManualTagHolder<class_1792>> BREADS = bind("breads", tp -> tp.addTagHolder(WHEAT_BREADS.get()).addOptionalTag(cLoc("bread")));
    public static final Supplier<ManualTagHolder<class_1792>> VEGETABLES = bind("vegetables", tp -> tp.add(class_1802.field_8179, class_1802.field_8567, class_1802.field_8186));
    public static final Supplier<ManualTagHolder<class_1792>> CARROTS = bind("carrots", tp -> tp.add(class_1802.field_8179));
    public static final Supplier<ManualTagHolder<class_1792>> POTATOES = bind("potatoes", tp -> tp.add(class_1802.field_8567));
    public static final Supplier<ManualTagHolder<class_1792>> BEETROOTS = bind("beetroots", tp -> tp.add(class_1802.field_8186));
    public static final Supplier<ManualTagHolder<class_1792>> WHEAT_GRAINS = bind("wheat_grains", tp -> tp.add(class_1802.field_8861).addOptionalTag(cLoc("grain/wheat")));
    public static final Supplier<ManualTagHolder<class_1792>> GRAINS = bind("grains", tp -> tp.addTagHolder(WHEAT_GRAINS.get()).addOptionalTag(cLoc("grain")));
    public static final Supplier<ManualTagHolder<class_1792>> SEEDS = bind("seeds", tp -> tp.add(class_1802.field_8317, class_1802.field_8309, class_1802.field_8188, class_1802.field_8706));
    public static final Supplier<ManualTagHolder<class_1792>> FRUITS = bind("fruits", tp -> tp.add(class_1802.field_8279, class_1802.field_17522, class_1802.field_16998, class_1802.field_28659, class_1802.field_8233));
    public static final Supplier<ManualTagHolder<class_1792>> MILKS = bind("milks", tp -> tp.add(class_1802.field_8103));
    public static final Supplier<ManualTagHolder<class_1792>> DRINKS = bind("drinks", tp -> tp.addOptionalTag(drinks()).addTagHolder(MILKS.get()));
    public static final Supplier<ManualTagHolder<class_1792>> SLIMEBALLS = bind("slimeballs", tp -> tp.add(class_1802.field_8777));
    public static final Supplier<ManualTagHolder<class_1792>> SLIME_BALLS = bind("slime_balls", tp -> tp.add(class_1802.field_8777));
    public static final Supplier<ManualTagHolder<class_1792>> CLAY = bind("clay", tp -> tp.add(class_1802.field_8696));

    private static Supplier<ManualTagHolder<class_1792>> bind(String id, Consumer<IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<class_1792>> tagRegister) {
        return Suppliers.memoize(() -> ManualTagHolder.of(TagRegistration.ITEM_TAG_REGISTRATION.registerCommon(id), tagRegister));
    }

    private static Supplier<class_6862<class_1792>> bind(String id) {
        return Suppliers.memoize(() -> TagRegistration.ITEM_TAG_REGISTRATION.registerCommon(id));
    }

    private static class_2960 cLoc(String path) {
        return new class_2960("c", path);
    }

    private static class_2960[] drinks() {
        return new class_2960[]{cLoc("juices"), cLoc("banana_smoothies"), cLoc("strawberry_smoothies"), cLoc("coffees"), cLoc("lemonades"), cLoc("limeades"), cLoc("kale_smoothies"), cLoc("fruit_smoothies"), cLoc("chocolate_milkshakes"), cLoc("beers"), cLoc("wines"), cLoc("meads"), cLoc("rums"), cLoc("pumpkin_spice_lattes"), cLoc("milk_bottles"), cLoc("tea")};
    }
}
