package dev.felnull.otyacraftengine.mixin.client;

import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_759.class_5773;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_759.class)
public class ItemInHandRendererMixin {
    @Shadow
    @Final
    private class_310 minecraft;
    @Shadow
    private class_1799 mainHandItem;
    @Shadow
    private class_1799 offHandItem;

    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;isHandsBusy()Z"))
    private void tick(CallbackInfo ci) {
        var mitem = minecraft.field_1724.method_6047();
        if (!OEClientEventHooks.onChangeHandHeight(class_1268.field_5808, this.mainHandItem, mitem)) {
            this.mainHandItem = mitem;
        }

        var oitem = minecraft.field_1724.method_6079();
        if (!OEClientEventHooks.onChangeHandHeight(class_1268.field_5810, this.offHandItem, oitem)) {
            this.offHandItem = oitem;
        }

    }

    @Inject(method = "evaluateWhichHandsToRender", at = @At("RETURN"), cancellable = true)
    private static void evaluateWhichHandsToRender(class_746 localPlayer, CallbackInfoReturnable<class_759.class_5773> cir) {
        var ret = toHandRenderSelection(OEClientEventHooks.onEvaluateWhichHandsToRender(toHandRenderSelectionWrapper(cir.getReturnValue()), localPlayer));
        if (ret != cir.getReturnValue())
            cir.setReturnValue(ret);
    }

    private static ClientEvent.HandRenderSelectionWrapper toHandRenderSelectionWrapper(class_759.class_5773 handRenderSelection) {
        return switch (handRenderSelection) {
            case field_28384 -> ClientEvent.HandRenderSelectionWrapper.RENDER_BOTH_HANDS;
            case field_28385 -> ClientEvent.HandRenderSelectionWrapper.RENDER_MAIN_HAND_ONLY;
            case field_28386 -> ClientEvent.HandRenderSelectionWrapper.RENDER_OFF_HAND_ONLY;
        };
    }

    private static class_759.class_5773 toHandRenderSelection(ClientEvent.HandRenderSelectionWrapper handRenderSelectionWrapper) {
        return switch (handRenderSelectionWrapper) {
            case RENDER_BOTH_HANDS -> class_759.class_5773.field_28384;
            case RENDER_MAIN_HAND_ONLY -> class_759.class_5773.field_28385;
            case RENDER_OFF_HAND_ONLY -> class_759.class_5773.field_28386;
        };
    }
}
