package dev.felnull.otyacraftengine.shape;

import net.minecraft.class_2350;
import net.minecraft.class_238;
import org.apache.commons.lang3.tuple.Triple;

public enum RotateAngledAxis {
    Y90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sz, sy, 1 - sx, ez, ey, 1 - ex), class_2350.class_2351.field_11052, 90),
    Y180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(1 - sx, sy, 1 - sz, 1 - ex, ey, 1 - ez), class_2350.class_2351.field_11052, 180),
    Y270((sx, sy, sz, ex, ey, ez) -> {
        var pos = Y180.convert.convert(sx, sy, sz, ex, ey, ez);
        return new ConvertPos(pos.sz(), pos.sy(), 1 - pos.sx(), pos.ez(), pos.ey(), 1 - pos.ex());
    }, class_2350.class_2351.field_11052, 270),
    X90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sy, sx, sz, ey, ex, ez), class_2350.class_2351.field_11048, 90),
    X180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(1 - sx, 1 - sy, sz, 1 - ex, 1 - ey, ez), class_2350.class_2351.field_11048, 180),
    X270((sx, sy, sz, ex, ey, ez) -> {
        var pos = Y180.convert.convert(sx, sy, sz, ex, ey, ez);
        return new ConvertPos(1 - pos.sy(), pos.sx(), pos.sz(), 1 - pos.ey(), pos.ex(), pos.ez());
    }, class_2350.class_2351.field_11048, 270),
    Z90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sx, sz, sy, ex, ez, ey), class_2350.class_2351.field_11051, 90),
    Z180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sx, 1 - sy, 1 - sz, ex, 1 - ey, 1 - ez), class_2350.class_2351.field_11051, 180);

    private final ConvertRot convert;
    private final class_2350.class_2351 axis;
    private final float angle;

    RotateAngledAxis(ConvertRot convert, class_2350.class_2351 axis, float angle) {
        this.convert = convert;
        this.axis = axis;
        this.angle = angle;
    }

    public class_2350.class_2351 getAxis() {
        return axis;
    }

    public float getAngle() {
        return angle;
    }

    public class_238 rotationAABB(class_238 aabb) {
        var cp = convert.convert(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
        return new class_238(cp.sx(), cp.sy(), cp.sz(), cp.ex(), cp.ey(), cp.ez());
    }

    public VoxelEdge rotationEdge(VoxelEdge edge) {
        var cp = convert.convert(edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ());
        return new VoxelEdge(cp.sx(), cp.sy(), cp.sz(), cp.ex(), cp.ey(), cp.ez());
    }

    public Triple<Float, Float, Float> getRotation() {
        float x = 0;
        float y = 0;
        float z = 0;

        switch (axis) {
            case field_11048 -> x = angle;
            case field_11052 -> y = angle;
            case field_11051 -> z = angle;
        }
        return Triple.of(x, y, z);
    }

    private static interface ConvertRot {
        ConvertPos convert(double sx, double sy, double sz, double ex, double ey, double ez);
    }

    private static record ConvertPos(double sx, double sy, double sz, double ex, double ey, double ez) {
    }
}