package dev.felnull.otyacraftengine.advancement;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import net.minecraft.advancements.critereon.*;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;

public class MODRootTrigger extends SimpleCriterionTrigger<MODRootTrigger.TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation(OtyacraftEngine.MODID, "mod_root");

    @Override
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Override
    protected TriggerInstance m_7214_(JsonObject jsonObject, EntityPredicate.@NotNull Composite composite, @NotNull DeserializationContext deserializationContext) {
        String mid = jsonObject.has("modid") ? jsonObject.get("modid").getAsString() : null;
        return new TriggerInstance(composite, mid);
    }

    public void trigger(ServerPlayer serverPlayer, ItemStack itemStack) {
        this.m_66234_(serverPlayer, (triggerInstance) -> triggerInstance.matches(itemStack));
    }

    public static class TriggerInstance extends AbstractCriterionTriggerInstance {
        @Nullable
        private final String modId;

        public TriggerInstance(EntityPredicate.Composite composite, @Nullable String modId) {
            super(ID, composite);
            this.modId = modId;
        }

        private boolean matches(ItemStack stack) {
            var id = Registry.f_122827_.m_7981_(stack.m_41720_());
            return id.getNamespace().equals(modId);
        }

        @Override
        public JsonObject m_7683_(@NotNull SerializationContext serializationContext) {
            var jo = super.m_7683_(serializationContext);
            if (modId != null)
                jo.addProperty("modid", modId);
            return jo;
        }
    }
}
