package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.components.base.IOEBaseComponent;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

import java.util.List;
import java.util.function.Function;

public class FixedButtonsList<E> extends AbstractWidget implements IOEBaseComponent {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final List<E> list;
    private final Function<E, Component> listName;
    private final PressEntry<E> onPress;
    private final int xTexStart;
    private final int yTexStart;
    private final int wTex;
    private final int hTex;
    private final ResourceLocation resourceLocation;
    protected int num;
    protected int hoveredNumber;
    protected boolean isHoveredScrollBar;
    private float scrollAmount;
    private boolean canScroll;

    public FixedButtonsList(int x, int y, int w, int h, ResourceLocation resource, int tx, int ty, int tw, int th, int num, Component name, List<E> list, Function<E, Component> listName, PressEntry<E> onPressEntry) {
        super(x, y, w, h, name);
        this.list = list;
        this.listName = listName;
        this.num = num;
        this.onPress = onPressEntry;
        this.resourceLocation = resource;
        this.xTexStart = tx;
        this.yTexStart = ty;
        this.wTex = tw;
        this.hTex = th;
    }

    @Override
    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mx, int my, float parTick) {
        if (f_93624_) {
            this.hoveredNumber = (my - f_93621_) / getOneButtonHeight();
            this.isHoveredScrollBar = mx >= this.f_93620_ + getOneButtonWidth() && my >= this.f_93621_ && mx < this.f_93620_ + this.f_93618_ && my < this.f_93621_ + this.f_93619_;
        }
        super.m_6305_(poseStack, mx, my, parTick);
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mx, int my, float parTick) {
        for (int i = 0; i < num; i++) {
            int cn = getCurrentFirstNumber() + i;

            if (cn >= list.size() || cn < 0)
                break;

            renderOneButton(poseStack, getList().get(cn), cn, i, f_93620_, f_93621_ + getOneButtonHeight() * i, mx, my, parTick);
        }

        renderScrollbar(poseStack, this.f_93620_ + getOneButtonWidth(), this.f_93621_, 9, f_93619_);

    }

    protected void renderScrollbar(PoseStack poseStack, int x, int y, int w, int h) {

        boolean hv = isHoveredScrollBar();

        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y, xTexStart + (hv ? 9 : 0), yTexStart, 9, 3, wTex, hTex);
        int bsct = (f_93619_ - 6) / 16;
        for (int i = 0; i < bsct; i++) {
            OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + 3 + (i * 16), xTexStart + (hv ? 9 : 0), yTexStart + 3, 9, 16, wTex, hTex);
        }
        int bsam = (f_93619_ - 6) % 16;
        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + 3 + (bsct * 16), xTexStart + (hv ? 9 : 0), yTexStart + 3, 9, bsam, wTex, hTex);
        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + f_93619_ - 3, xTexStart + (hv ? 9 : 0), yTexStart + 19, 9, 3, wTex, hTex);

        int barHeight = getBarHeight();
        float barY = ((f_93619_ - 2) - barHeight) * scrollAmount;


        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 1 + barY, xTexStart + (hv ? 7 : 0), yTexStart + 22, 7, 3, wTex, hTex);
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; i++) {
            OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 4 + (i * 14) + barY, xTexStart + (hv ? 7 : 0), yTexStart + 25, 7, 14, wTex, hTex);
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 4 + (ssct * 14) + barY, xTexStart + (hv ? 7 : 0), yTexStart + 25, 7, ssam, wTex, hTex);
        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 1 + barHeight - 3 + barY, xTexStart + (hv ? 7 : 0), yTexStart + 39, 7, 3, wTex, hTex);
    }


    protected void renderOneButton(PoseStack poseStack, E item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_(0, f_93617_);
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, this.f_93625_);
        int k = this.m_7202_(this.isHoveredOrFocused(bnum));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, x, y, 0, 46 + k * 20, getOneButtonWidth() / 2, getOneButtonHeight());
        this.m_93228_(poseStack, x + getOneButtonWidth() / 2, y, 200 - getOneButtonWidth() / 2, 46 + k * 20, getOneButtonWidth() / 2, getOneButtonHeight());
        this.m_7906_(poseStack, mc, mx, my);

        int l = this.f_93623_ ? 16777215 : 10526880;
        m_93215_(poseStack, mc.f_91062_, this.getMessage(lnum), this.f_93620_ + getOneButtonWidth() / 2, y + (getOneButtonHeight() - 8) / 2, l | Mth.m_14167_(this.f_93625_ * 255.0F) << 24);
    }

    public List<E> getList() {
        return list;
    }

    public boolean isHoveredOrFocused(int lnum) {
        return m_198029_() && hoveredNumber == lnum && !isHoveredScrollBar;
    }

    public Component getMessage(int index) {
        return listName.apply(list.get(index));
    }

    public int getOneButtonHeight() {
        return f_93619_ / num;
    }

    public int getOneButtonWidth() {
        return f_93618_ - 9;
    }

    public float getScrollAmount() {
        return scrollAmount;
    }

    public void setScrollAmount(float d) {
        this.scrollAmount = Mth.m_14036_(d, 0f, 1f);
    }

    @Override
    public void m_5716_(double mx, double my) {
        onPress((int) ((my - f_93621_) / getOneButtonHeight()));
    }

    public boolean isHoveredScrollBar() {
        return this.m_198029_() && isHoveredScrollBar;
    }

    public void onPress(int num) {
        int cn = getCurrentFirstNumber() + num;

        if (cn < list.size() && isHoveredOrFocused(num))
            onPress.onPressEntry(this, list.get(cn), cn, num);
    }

    public int getBarHeight() {
        return Mth.m_14045_((f_93619_ - 2) / ((list.size() / num) + 1), 10, f_93619_ - 2);
    }

    protected int getCurrentFirstNumber() {


        if (list.size() <= num)
            return 0;

        return (int) ((list.size() - num) * scrollAmount);
    }

    @Override
    public boolean m_6375_(double mx, double my, int i) {
        canScroll = isHoveredScrollBar();
        scroll(my);
        return super.m_6375_(mx, my, i);
    }

    @Override
    public boolean m_7979_(double mx, double my, int i, double f, double g) {
        scroll(my);
        return super.m_7979_(mx, my, i, f, g);
    }

    @Override
    public boolean m_6050_(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - (float) f * ((float) num / (float) f_93619_));
        return true;
    }

    public void scroll(double mouseY) {
        if (canScroll) {
            int cy = (int) (mouseY - this.f_93621_ - 1 - getBarHeight() / 2);
            int sa = f_93619_ - 2 - getBarHeight();
            if (sa > 0) {
                setScrollAmount((float) cy / (float) sa);
            }
        }
    }

    public static interface PressEntry<E> {
        void onPressEntry(FixedButtonsList<E> buttonsList, E item, int itemNum, int num);
    }
}
