package dev.felnull.otyacraftengine.inventory;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class OEBaseMenu extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final Container container;

    protected OEBaseMenu(@Nullable MenuType<?> menuType, int i, Inventory playerInventory, Container container, int playerSlotX, int playerSlotY) {
        super(menuType, i);
        this.playerInventory = playerInventory;
        this.container = container;
        setSlot();
        setPlayerSlot(playerSlotX, playerSlotY);
    }

    protected abstract void setSlot();

    @Override
    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    protected boolean isActiveOffHandSlot() {
        return false;
    }

    public Container getContainer() {
        return container;
    }

    protected void setPlayerSlot(int x, int y) {
        if (x >= 0 && y >= 0) {
            IntStream.range(0, 3).forEach(k -> IntStream.range(0, 9).forEach(i1 -> this.m_38897_(new Slot(playerInventory, i1 + k * 9 + 9, x + i1 * 18, y + k * 18))));
            IntStream.range(0, 9).forEach(l -> this.m_38897_(new Slot(playerInventory, l, x + l * 18, y + 58)));
            if (isActiveOffHandSlot())
                this.m_38897_(new Slot(playerInventory, Inventory.f_150066_, x + 166, y + 58) {
                    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                        return Pair.of(InventoryMenu.f_39692_, InventoryMenu.f_39697_);
                    }
                });
        }
    }

    public Inventory getPlayerInventory() {
        return playerInventory;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotitem = slot.m_7993_();
            itemstack = slotitem.m_41777_();
            if (index <= getNonPlayerInventorySlotCount() - 1) {
                if (!this.m_38903_(slotitem, getNonPlayerInventorySlotCount(), 36 + getNonPlayerInventorySlotCount(), false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index <= getNonPlayerInventorySlotCount() + 26) {
                for (int i = 0; i < getNonPlayerInventorySlotCount(); i++) {
                    if (getNonPlayerInventorySlots().get(i).m_5857_(slotitem) && !this.m_38903_(slotitem, i, i + 1, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                if (!this.m_38903_(slotitem, getNonPlayerInventorySlotCount() + 27, getNonPlayerInventorySlotCount() + 36, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                for (int i = 0; i < getNonPlayerInventorySlotCount(); i++) {
                    if (getNonPlayerInventorySlots().get(i).m_5857_(slotitem) && !this.m_38903_(slotitem, i, i + 1, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                if (!this.m_38903_(slotitem, getNonPlayerInventorySlotCount(), getNonPlayerInventorySlotCount() + 26, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotitem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotitem.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotitem);
        }
        return itemstack;
    }

    public int getNonPlayerInventorySlotCount() {
        return getNonPlayerInventorySlots().size();
    }

    public List<Slot> getNonPlayerInventorySlots() {
        return f_38839_.stream().filter(n -> n.f_40218_ != getPlayerInventory()).collect(Collectors.toList());
    }

    abstract public boolean isBlock();
}
