package dev.felnull.otyacraftengine.vsg;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TentativeVoxelShapeGenerator {
    public static JsonObject generate(VoxelShape shape, VoxelShape edge) {
        long st = System.currentTimeMillis();
        JsonObject jo = new JsonObject();
        jo.addProperty("time", System.currentTimeMillis());
        jo.addProperty("meta", "OtyacraftEngine Tentative VoxelShapeGenerator V1");
        jo.addProperty("version", 2);

        JsonArray shapes = new JsonArray();
        for (AABB toAabb : shape.m_83299_()) {
            JsonArray aabb = new JsonArray();
            aabb.add(toAabb.f_82288_);
            aabb.add(toAabb.f_82289_);
            aabb.add(toAabb.f_82290_);
            aabb.add(toAabb.f_82291_);
            aabb.add(toAabb.f_82292_);
            aabb.add(toAabb.f_82293_);
            shapes.add(aabb);
        }
        jo.add("shapes", shapes);

        JsonArray edges = new JsonArray();
        edge.m_83224_((sx, sy, sz, ex, ey, ez) -> {
            JsonArray aabb = new JsonArray();
            aabb.add(sx);
            aabb.add(sy);
            aabb.add(sz);
            aabb.add(ex);
            aabb.add(ey);
            aabb.add(ez);
            edges.add(aabb);
        });

        jo.add("edges", edges);

        jo.addProperty("elapsed", System.currentTimeMillis() - st);
        return jo;
    }
}
