/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.block.IIkisugiVoxelShape;
import dev.felnull.otyacraftengine.block.RotateAngledAxis;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IkisugiVoxelShape {
    private static final IkisugiVoxelShape INSTANCE = new IkisugiVoxelShape();

    public static IkisugiVoxelShape getInstance() {
        return INSTANCE;
    }

    public VoxelShape getShapeFromJson(JsonObject shapeJson) {
        JsonElement version = shapeJson.get("version");
        if (version != null && version.getAsInt() == 2) {
            return this.getShapeFromJsonV2(shapeJson);
        }
        return this.getShapeFromJsonV1(shapeJson);
    }

    private VoxelShape getShapeFromJsonV1(JsonObject shapeJ) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes.add(shape);
        }
        return OEVoxelShapeUtil.uniteBox(shapes);
    }

    private VoxelShape getShapeFromJsonV2(JsonObject shapeJ) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            VoxelShape shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble() * 16.0, ja.get(1).getAsDouble() * 16.0, ja.get(2).getAsDouble() * 16.0, ja.get(3).getAsDouble() * 16.0, ja.get(4).getAsDouble() * 16.0, ja.get(5).getAsDouble() * 16.0);
            shapes.add(shape);
        }
        VoxelShape shape = OEVoxelShapeUtil.uniteBox(shapes);
        HashSet<IIkisugiVoxelShape.Edge> edges = new HashSet<IIkisugiVoxelShape.Edge>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("edges")) {
            JsonArray ja = jshape.getAsJsonArray();
            edges.add(new IIkisugiVoxelShape.Edge(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble()));
        }
        ((IIkisugiVoxelShape)shape).setEdges(Collections.unmodifiableSet(edges));
        return shape;
    }

    public VoxelShape copy(VoxelShape target, IIkisugiVoxelShape source) {
        ((IIkisugiVoxelShape)target).setEdges(source.getEdges());
        return target;
    }

    public VoxelShape unite(VoxelShape target, VoxelShape ... shapes) {
        HashSet<IIkisugiVoxelShape.Edge> edges = new HashSet<IIkisugiVoxelShape.Edge>();
        for (VoxelShape shape : shapes) {
            Set<IIkisugiVoxelShape.Edge> shp = ((IIkisugiVoxelShape)shape).getEdges();
            if (shp == null) continue;
            edges.addAll(shp);
        }
        ((IIkisugiVoxelShape)target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public VoxelShape unite(VoxelShape target, List<IIkisugiVoxelShape> shapes) {
        HashSet edges = new HashSet();
        shapes.forEach(n -> {
            Set<IIkisugiVoxelShape.Edge> shp = n.getEdges();
            if (shp != null) {
                edges.addAll(shp);
            }
        });
        ((IIkisugiVoxelShape)target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public VoxelShape move(VoxelShape target, IIkisugiVoxelShape source, double x, double y, double z) {
        x /= 16.0;
        y /= 16.0;
        z /= 16.0;
        HashSet<IIkisugiVoxelShape.Edge> edges = new HashSet<IIkisugiVoxelShape.Edge>();
        if (source.getEdges() == null) {
            return target;
        }
        for (IIkisugiVoxelShape.Edge edge : source.getEdges()) {
            edges.add(new IIkisugiVoxelShape.Edge(edge.stX() + x, edge.stY() + y, edge.stZ() + z, edge.enX() + x, edge.enY() + y, edge.enZ() + z));
        }
        ((IIkisugiVoxelShape)target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public VoxelShape rotate(VoxelShape target, IIkisugiVoxelShape source, RotateAngledAxis angledAxis) {
        HashSet<IIkisugiVoxelShape.Edge> edges = new HashSet<IIkisugiVoxelShape.Edge>();
        if (source.getEdges() == null) {
            return target;
        }
        for (IIkisugiVoxelShape.Edge edge : source.getEdges()) {
            edges.add(angledAxis.convertEdge(edge));
        }
        ((IIkisugiVoxelShape)target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }
}

