/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Tickable;

public class DynamicGifTexture
extends DynamicTexture
implements Tickable {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    public DynamicGifTexture(long duration, ImageFrame ... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    public void m_7673_() {
        int ct = Math.toIntExact(this.getFrameByTime(System.currentTimeMillis() % this.duration));
        if (ct != this.last) {
            this.f_117977_ = this.frames[ct].image();
            this.m_117985_();
            this.last = ct;
        }
    }

    private int getFrameByTime(long time) {
        long dr = 0L;
        for (int i = 0; i < this.frames.length; ++i) {
            if (dr <= time && dr + this.frames[i].delay > time) {
                return i;
            }
            dr += this.frames[i].delay;
        }
        return 0;
    }

    public void close() {
        super.close();
        if (this.frames != null) {
            for (ImageFrame image : this.frames) {
                if (image == null) continue;
                image.image().close();
            }
        }
    }

    public record ImageFrame(NativeImage image, long delay) {
    }
}

