/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.screen.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.BakedModelRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.IRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.ItemRenderTest;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderTestScreen
extends OEBaseScreen {
    private static final List<IRenderTest> renderTests = new ArrayList<IRenderTest>();
    private int currentTest;
    private long eqAll;
    private long lastTime = -1L;
    private long rtAll;
    private int sampleCount;
    private int testCount = 1;
    private Motion motion = Motion.FIX;
    private Vector3f cameraPos = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f cameraRot = new Vector3f();
    private EditBox countBox;

    public RenderTestScreen(@Nullable Screen parent) {
        super((Component)new TextComponent("Render Test"), parent);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(3, this.f_96544_ - 23, 100, 20, CommonComponents.f_130660_, n -> mc.m_91152_(this.getParentScreen())));
        this.m_142416_((GuiEventListener)new Button(106, this.f_96544_ - 23, 100, 20, (Component)new TextComponent("Reset"), n -> this.reset()));
        this.countBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(RenderTestScreen.mc.f_91062_, 209, this.f_96544_ - 23, 70, 20, (Component)new TextComponent("Count")));
        this.countBox.m_94144_(String.valueOf(this.testCount));
        this.countBox.m_94151_(n -> {
            block5: {
                if (!n.isEmpty()) {
                    try {
                        int val = Integer.parseInt(n);
                        if (val < 0) {
                            this.countBox.m_94144_("0");
                            break block5;
                        }
                        this.setCount(val);
                    }
                    catch (NumberFormatException e) {
                        this.countBox.m_94144_("0");
                    }
                } else {
                    this.countBox.m_94144_("0");
                }
            }
        });
        this.m_142416_((GuiEventListener)new Button(282, this.f_96544_ - 23, 20, 20, (Component)new TextComponent("-1"), n -> this.countBox.m_94144_(String.valueOf(this.testCount - 1))));
        this.m_142416_((GuiEventListener)new Button(305, this.f_96544_ - 23, 20, 20, (Component)new TextComponent("+1"), n -> this.countBox.m_94144_(String.valueOf(this.testCount + 1))));
        this.m_142416_((GuiEventListener)new Button(328, this.f_96544_ - 23, 100, 20, (Component)new TextComponent("Motion: " + this.motion.name()), n -> {
            this.motion = Motion.values()[(this.motion.ordinal() + 1) % Motion.values().length];
            n.m_93666_((Component)new TextComponent("Motion: " + this.motion.name()));
        }));
        if (!renderTests.isEmpty()) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 23, 3, 20, 20, (Component)new TextComponent("->"), n -> {
                this.currentTest = (this.currentTest + 1) % renderTests.size();
                this.reset();
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 46, 3, 20, 20, (Component)new TextComponent("<-"), n -> {
                this.currentTest = (this.currentTest - 1) % renderTests.size();
                if (this.currentTest < 0) {
                    this.currentTest = renderTests.size() - 1;
                }
                this.reset();
            }));
        }
        this.reset();
    }

    private void setCount(int count) {
        this.testCount = count;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mx, int my, float f) {
        long rt = System.nanoTime() - this.lastTime;
        if (this.lastTime >= 0L) {
            this.rtAll += rt;
        }
        this.m_96626_(0);
        float sy = (float)this.f_96544_ - (float)this.f_96544_ / 4.0f;
        this.drawRelativeFill(poseStack, 0.0f, 0.0f, this.f_96543_, sy, -1);
        this.drawRelativeFill(poseStack, 0.0f, 0.0f, this.f_96543_, sy - 1.0f, -16777216);
        super.m_6305_(poseStack, mx, my, f);
        if (renderTests.isEmpty()) {
            return;
        }
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        long st = System.nanoTime();
        this.renderTest(poseStack, (MultiBufferSource)buf, f, this.testCount);
        long eq = System.nanoTime() - st;
        buf.m_109911_();
        this.eqAll += eq;
        ++this.sampleCount;
        float eqAvg = (float)this.eqAll / (float)this.sampleCount;
        float rtAvg = (float)this.rtAll / (float)(this.sampleCount - 1);
        this.drawTextBase(poseStack, RenderTestScreen.mc.f_90977_, 3.0f, sy, 0xFFFFFF);
        String string = String.format("Rendering Time: %.3fms %06dns", Float.valueOf((float)eq / 1000000.0f), eq);
        Objects.requireNonNull(RenderTestScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string, 3.0f, sy + 9.0f + 1.0f, 0xFFFFFF);
        String string2 = String.format("Rendering Average Time: %.3fms %06dns", Float.valueOf(eqAvg / 1000000.0f), (int)eqAvg);
        Objects.requireNonNull(RenderTestScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string2, 3.0f, sy + (float)((9 + 1) * 2), 0xFFFFFF);
        String string3 = String.format("Return Time: %.3fms %06dns", Float.valueOf((float)rt / 1000000.0f), rt);
        float f2 = 3.0f + (float)this.f_96543_ / 2.0f;
        Objects.requireNonNull(RenderTestScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string3, f2, sy + 9.0f + 1.0f, 0xFFFFFF);
        String string4 = String.format("Return Average Time: %.3fms %06dns", Float.valueOf(rtAvg / 1000000.0f), (int)rtAvg);
        float f3 = 3.0f + (float)this.f_96543_ / 2.0f;
        Objects.requireNonNull(RenderTestScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string4, f3, sy + (float)((9 + 1) * 2), 0xFFFFFF);
        this.lastTime = System.nanoTime();
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.motion == Motion.FREE_LOOK) {
            float speed = 1.0f;
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92085_)) {
                this.cameraPos.m_122272_(0.0f, -speed, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92087_)) {
                this.cameraPos.m_122272_(0.0f, speed, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92088_)) {
                this.cameraPos.m_122272_(speed, 0.0f, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92086_)) {
                this.cameraPos.m_122272_(-speed, 0.0f, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92091_)) {
                this.cameraPos = new Vector3f(0.0f, 0.0f, 1.0f);
                this.cameraRot = new Vector3f();
            }
        }
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.motion == Motion.FREE_LOOK) {
            this.cameraRot.m_122272_(-((float)g), (float)f, 0.0f);
        }
        return super.m_7979_(d, e, i, f, g);
    }

    public boolean m_6050_(double d, double e, double f) {
        if (this.motion == Motion.FREE_LOOK) {
            this.cameraPos.m_122272_(0.0f, 0.0f, (float)f * (OEClientUtil.isKeyInput(RenderTestScreen.mc.f_91066_.f_92090_) ? 0.5f : 1.0f));
            this.cameraPos.m_122245_(this.cameraPos.m_122239_(), this.cameraPos.m_122260_(), Math.max(this.cameraPos.m_122269_(), 1.0f));
        }
        return super.m_6050_(d, e, f);
    }

    private void reset() {
        this.eqAll = 0L;
        this.sampleCount = 0;
        this.lastTime = -1L;
        this.rtAll = 0L;
    }

    private void renderTest(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float f, int count) {
        float sy = (float)this.f_96544_ - (float)this.f_96544_ / 4.0f;
        poseStack.m_85836_();
        if (this.motion != Motion.TRANSLATED && this.motion != Motion.ROTED && this.motion != Motion.BOTH) {
            double x = (float)this.f_96543_ / 2.0f;
            double y = sy / 2.0f;
            if (this.motion == Motion.FREE_LOOK) {
                poseStack.m_85837_(x += (double)(this.cameraPos.m_122239_() * this.cameraPos.m_122269_()), y += (double)(this.cameraPos.m_122260_() * this.cameraPos.m_122269_()), 30.0);
                OERenderUtil.poseRotateAll(poseStack, this.cameraRot.m_122239_(), this.cameraRot.m_122260_(), this.cameraRot.m_122269_());
                poseStack.m_85837_(-x, -y, -30.0);
            }
            poseStack.m_85837_(x, y, 1050.0);
            poseStack.m_85841_(1.0f, 1.0f, -1.0f);
            poseStack.m_85837_(0.0, 0.0, 1000.0);
            poseStack.m_85841_(30.0f, -30.0f, 30.0f);
            if (this.motion == Motion.FREE_LOOK) {
                OERenderUtil.poseScaleAll(poseStack, this.cameraPos.m_122269_());
            }
        }
        for (int i = 0; i < count; ++i) {
            float sp = OERenderUtil.getParSecond(5000L) + 1.0f / (float)count * (float)i;
            if (sp > 1.0f) {
                sp -= 1.0f;
            }
            poseStack.m_85836_();
            double x = (float)this.f_96543_ / 2.0f;
            double y = sy / 2.0f;
            if (this.motion == Motion.TRANSLATED || this.motion == Motion.BOTH) {
                float par = (float)((double)sp * Math.toRadians(360.0));
                x += Math.sin(par) * (double)((float)this.f_96543_ / 2.0f - 30.0f);
                y += Math.sin(2.0f * par) * (double)(sy / 2.0f - 30.0f);
            }
            if (this.motion == Motion.ROTED || this.motion == Motion.BOTH) {
                poseStack.m_85837_(x, y, 30.0);
                OERenderUtil.poseRotateX(poseStack, sp * 360.0f);
                OERenderUtil.poseRotateY(poseStack, sp * 360.0f);
                OERenderUtil.poseRotateZ(poseStack, sp * 360.0f);
                poseStack.m_85837_(-x, -y, -30.0);
            }
            if (this.motion == Motion.TRANSLATED || this.motion == Motion.ROTED || this.motion == Motion.BOTH) {
                poseStack.m_85837_(x, y, 1050.0);
                poseStack.m_85841_(1.0f, 1.0f, -1.0f);
                poseStack.m_85837_(0.0, 0.0, 1000.0);
                poseStack.m_85841_(30.0f, -30.0f, 30.0f);
            }
            this.renderTest(poseStack, multiBufferSource, f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderTest(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float f) {
        IRenderTest rt = renderTests.get(this.currentTest);
        rt.renderTest(poseStack, multiBufferSource, f);
    }

    public static void addRenderTest(IRenderTest renderTest) {
        renderTests.add(renderTest);
    }

    public static void fInit() {
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(new ResourceLocation("otyacraftengine", "block/test_model")));
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(new ResourceLocation("otyacraftengine", "item/test_item_kame")));
        RenderTestScreen.addRenderTest(new ItemRenderTest((ItemLike)Items.f_42410_));
        RenderTestScreen.addRenderTest(new ItemRenderTest((ItemLike)Items.f_41913_));
    }

    private static enum Motion {
        FIX,
        TRANSLATED,
        ROTED,
        BOTH,
        FREE_LOOK;

    }
}

