/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import dev.felnull.otyacraftengine.client.gui.subtitle.IDynamicSubtitle;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.util.OELangUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class OEClientUtil {
    protected static final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<String, GameProfile>();
    private static final Minecraft mc = Minecraft.m_91087_();

    public static GameProfile getClientPlayerProfile(String name) {
        if (PLAYER_PROFILES.containsKey(name)) {
            return PLAYER_PROFILES.get(name);
        }
        GameProfile gp = new GameProfile(null, name);
        PLAYER_PROFILES.put(name, gp);
        SkullBlockEntity.m_155738_((GameProfile)gp, n -> PLAYER_PROFILES.put(name, (GameProfile)n));
        return gp;
    }

    public static boolean isKeyInput(int keyCode) {
        if (keyCode < 0) {
            return false;
        }
        long winID = Minecraft.m_91087_().m_91268_().m_85439_();
        if (keyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)winID, (int)keyCode) == 1;
        }
        return InputConstants.m_84830_((long)winID, (int)keyCode);
    }

    public static boolean isKeyInput(KeyMapping keyCode) {
        return OEClientUtil.isKeyInput(OEClientExpectPlatform.getKey(keyCode).m_84873_());
    }

    public static Optional<String> getPlayerNameByUUID(@NotNull UUID uuid) {
        PlayerInfo pi;
        if (OEClientUtil.mc.f_91074_ != null && (pi = OEClientUtil.mc.f_91074_.f_108617_.m_104949_(uuid)) != null) {
            return Optional.of(pi.m_105312_().getName());
        }
        return PlayerInfoManager.getInstance().getNameByUUID(uuid);
    }

    public static Optional<UUID> getPlayerUUIDByName(@NotNull String name) {
        PlayerInfo pi = OEClientUtil.mc.f_91074_.f_108617_.m_104938_(name);
        if (pi != null) {
            return Optional.of(pi.m_105312_().getId());
        }
        return PlayerInfoManager.getInstance().getUUIDByName(name);
    }

    public static LanguageInfo getLanguageByGoogleCode(String googleCode) {
        Optional<String> str = OELangUtil.getLangIdByGoogleCode(googleCode);
        if (str.isPresent()) {
            return mc.m_91102_().m_118976_(str.get());
        }
        for (LanguageInfo language : mc.m_91102_().m_118984_()) {
            if (!language.getCode().split("_")[0].equals(googleCode)) continue;
            return language;
        }
        return mc.m_91102_().m_118976_("en_us");
    }

    public static String getGoogleCodeByLanguage(LanguageInfo language) {
        Optional<String> lng = OELangUtil.getGoogleCodeByLangId(language.getCode());
        if (lng.isPresent()) {
            return lng.get();
        }
        String name = language.getCode().split("_")[0];
        for (String lang : OELangUtil.googleLangCodes) {
            if (!lang.equals(name)) continue;
            return lang;
        }
        return "en";
    }

    public static void addSubtitle(SubtitleOverlay.Subtitle subtitle, boolean duplicate) {
        List subs = OEClientUtil.mc.f_91065_.f_92996_.f_94638_;
        if (!duplicate) {
            for (SubtitleOverlay.Subtitle sub : subs) {
                if (!sub.m_94655_().equals(subtitle.m_94655_())) continue;
                sub.m_94656_(subtitle.m_94659_());
                ((IDynamicSubtitle)sub).setDynamicLocation(((IDynamicSubtitle)subtitle).getDynamicLocation());
                return;
            }
        }
        subs.add(subtitle);
    }

    @Nullable
    public static File[] openFileChooser(String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects) {
        String st = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), null, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
        if (st == null) {
            return null;
        }
        try {
            if (allowMultipleSelects) {
                String[] sp = st.split("\\|");
                File[] fl = new File[sp.length];
                for (int i = 0; i < sp.length; ++i) {
                    fl[i] = new File(sp[i]);
                }
                return fl;
            }
            return new File[]{new File(st)};
        }
        catch (Exception ex) {
            return null;
        }
    }
}

