package dev.felnull.otyacraftengine.data.provider;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.tuple.Pair;
import record;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class ModelDivisionProviderWrapper extends DevToolProviderWrapper {
    private static final Gson GSON = new Gson();

    public ModelDivisionProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    protected abstract boolean isTarget(Path inputFolder, Path path);

    @Override
    public void run(CachedOutput cachedOutput) throws IOException {
        List<CompletableFuture<List<EntryResult>>> results = new ArrayList<>();

        var outPath = getGenerator().m_123916_();
        var inPaths = getCrossGeneratorAccess().getResourceInputFolders();

        for (Path path : inPaths) {
            try (var walk = Files.walk(path)) {
                walk.forEach(tp -> {
                    if (!Files.isDirectory(tp) && isTarget(path, tp))
                        results.add(CompletableFuture.supplyAsync(() -> task(outPath, path, tp), Util.m_183991_()));
                });
            }
        }

        for (CompletableFuture<List<EntryResult>> result : results) {
            try {
                var ret = result.get();
                for (EntryResult entryResult : ret) {
                    cachedOutput.m_213871_(entryResult.path, entryResult.data, entryResult.hash);
                }
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<EntryResult> task(Path outPath, Path inPath, Path path) {
        var rp = inPath.relativize(path);
        var op = outPath.resolve(rp);

        JsonObject model;
        try (Reader reader = new FileReader(path.toFile()); Reader bufReader = new BufferedReader(reader)) {
            model = GSON.fromJson(bufReader, JsonObject.class);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return divModel(FNStringUtil.removeExtension(op.toFile().getName()), model).entrySet().stream().map(ret -> {
            var name = ret.getKey();
            var divModel = ret.getValue();

            byte[] bs;
            HashCode hashCode;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(); HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), byteArrayOutputStream); InputStream stream = new ByteArrayInputStream(GSON.toJson(divModel).getBytes(StandardCharsets.UTF_8))) {
                FNDataUtil.i2o(stream, hashingOutputStream);
                bs = byteArrayOutputStream.toByteArray();
                hashCode = hashingOutputStream.hash();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }

            return new EntryResult(op.getParent().resolve(FNStringUtil.escapeFileName(name, "_")), bs, hashCode);
        }).toList();
    }

    protected Map<String, JsonObject> divModel(String name, JsonObject original) {
        return IntStream.range(0, 10).mapToObj(n -> {
            return Pair.of(name + "_" + n, original);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected boolean isChildDir(Path inputFolder, Path path, Path targetPath) {
        var rp = inputFolder.relativize(path);

        var rps = rp.toString().replace("\\", "/");
        var tps = targetPath.toString().replace("\\", "/");

        return rps.startsWith(tps);
    }

    @Override
    public String getName() {
        return "Model Division";
    }

    private static record EntryResult(Path path, byte[] data, HashCode hash) {
    }
}
