/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.callpoint;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.client.callpoint.ClientCallPoint;
import dev.felnull.otyacraftengine.client.callpoint.LayerRegister;
import dev.felnull.otyacraftengine.client.callpoint.ModelRegister;
import dev.felnull.otyacraftengine.util.OEUtils;
import java.util.List;
import java.util.function.Consumer;

public class ClientCallPointManager {
    private static final ClientCallPointManager INSTANCE = new ClientCallPointManager();
    private final List<ClientCallPoint> POINTS = ImmutableList.copyOf(OEUtils.getCallPoints("otyacraftengine_client", ClientCallPoint.Sign.class, ClientCallPoint.class));
    private final ClientCallPoint ALL_CALL_POINT = new ClientCallPoint(){

        @Override
        public void onModelRegistry(ModelRegister register) {
            ClientCallPointManager.this.consumer(n -> n.onModelRegistry(register));
        }

        @Override
        public void onLayerRegistry(LayerRegister register) {
            ClientCallPointManager.this.consumer(n -> n.onLayerRegistry(register));
        }
    };

    public static ClientCallPointManager getInstance() {
        return INSTANCE;
    }

    public ClientCallPoint call() {
        return this.ALL_CALL_POINT;
    }

    private void consumer(Consumer<ClientCallPoint> callPointConsumer) {
        for (ClientCallPoint point : this.POINTS) {
            callPointConsumer.accept(point);
        }
    }
}

