/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.MoreClientLifecycleEvents;
import dev.felnull.otyacraftengine.client.event.MoreRenderEvent;
import dev.felnull.otyacraftengine.client.event.OBJLoaderEvent;
import dev.felnull.otyacraftengine.client.event.TextureEvent;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OEClientEventHooks {
    public static void onLevelUnload(ClientLevel level) {
        ((ClientLifecycleEvent.ClientLevelState)MoreClientLifecycleEvents.CLIENT_LEVEL_UNLOAD.invoker()).act((Level)level);
    }

    public static boolean onOBJLoaderCheck(ResourceLocation resourceId) {
        return ((OBJLoaderEvent.LoadCheck)OBJLoaderEvent.LOAD_CHECK.invoker()).loadCheck(resourceId).isTrue();
    }

    public static boolean onRenderHand(PoseStack poseStack, MultiBufferSource multiBufferSource, InteractionHand hand, int packedLight, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return !((MoreRenderEvent.RenderItemInHand)MoreRenderEvent.RENDER_ITEM_IN_HAND.invoker()).renderItemInHand(poseStack, multiBufferSource, hand, packedLight, partialTicks, interpolatedPitch, swingProgress, equipProgress, stack).isFalse();
    }

    public static boolean onRenderArmWithItem(ItemInHandLayer<? extends LivingEntity, ? extends EntityModel<?>> layer, LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        EventResult event = ((MoreRenderEvent.RenderArmWithItem)MoreRenderEvent.RENDER_ARM_WITH_ITEM.invoker()).renderArmWithItem(layer, livingEntity, itemStack, transformType, humanoidArm, poseStack, multiBufferSource, i);
        return event.isEmpty() || event.isTrue();
    }

    public static boolean onChangeHandHeight(InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        EventResult event = ((ClientEvent.ChangeHandHeight)ClientEvent.CHANGE_HAND_HEIGHT.invoker()).changeHandHeight(hand, oldStack, newStack);
        return event.isEmpty() || event.isTrue();
    }

    public static boolean onPoseHumanoidArm(HumanoidArm arm, InteractionHand hand, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        EventResult event = ((ClientEvent.PoseHumanoidArm)ClientEvent.POSE_HUMANOID_ARM.invoker()).poseHumanoidArm(arm, hand, model, livingEntity);
        return event.isEmpty() || event.isTrue();
    }

    public static void onPoseHumanoidArmPost(HumanoidArm arm, InteractionHand hand, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        ((ClientEvent.PoseHumanoidArmPost)ClientEvent.POSE_HUMANOID_ARM_POST.invoker()).poseHumanoidArm(arm, hand, model, livingEntity);
    }

    public static void onIntegratedServerPauseChange(boolean paused) {
        ((ClientEvent.PauseChange)ClientEvent.INTEGRATED_SERVER_PAUSE.invoker()).onPauseChange(paused);
    }

    public static boolean onHandAttack(ItemStack itemStack) {
        EventResult event = ((ClientEvent.HandAttack)ClientEvent.HAND_ATTACK.invoker()).onHandAttack(itemStack);
        return event.isEmpty() || event.isTrue();
    }

    public static ClientEvent.HandRenderSelectionWrapper onEvaluateWhichHandsToRender(ClientEvent.HandRenderSelectionWrapper handRenderSelection, LocalPlayer player) {
        AtomicReference wrapperAtomicReference = new AtomicReference();
        ((ClientEvent.EvaluateRenderHands)ClientEvent.EVALUATE_RENDER_HANDS.invoker()).onEvaluateRenderHands(handRenderSelection, player, wrapperAtomicReference::set);
        ClientEvent.HandRenderSelectionWrapper ret = (ClientEvent.HandRenderSelectionWrapper)((Object)wrapperAtomicReference.get());
        return ret != null ? ret : handRenderSelection;
    }

    public static boolean onCheckTextureURL(String url) {
        return ((TextureEvent.CheckTextureURL)TextureEvent.CHECK_TEXTURE_URL.invoker()).onCheckURL(url).isTrue();
    }

    public static String onSwapTextureURL(String url) {
        final String[] nurl = new String[]{url};
        ((TextureEvent.SwapTextureURL)TextureEvent.SWAP_TEXTURE_URL.invoker()).onSwapURL(url, new TextureEvent.TextureURLSwapper(){

            @Override
            public void setURL(String url) {
                nurl[0] = url;
            }

            @Override
            public String getURL() {
                return nurl[0];
            }
        });
        return nurl[0];
    }
}

