/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DevToolProviderWrapper;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModelDivisionProviderWrapper
extends DevToolProviderWrapper {
    private static final Gson GSON = new Gson();

    public ModelDivisionProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    protected abstract boolean isTarget(Path var1, Path var2);

    @Override
    public void run(CachedOutput cachedOutput) throws IOException {
        ArrayList results = new ArrayList();
        Path outPath = this.getGenerator().m_123916_();
        Collection<Path> inPaths = this.getCrossGeneratorAccess().getResourceInputFolders();
        for (Path path : inPaths) {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                walk.forEach(tp -> {
                    if (!Files.isDirectory(tp, new LinkOption[0]) && this.isTarget(path, (Path)tp)) {
                        results.add(CompletableFuture.supplyAsync(() -> this.task(outPath, path, (Path)tp), Util.m_183991_()));
                    }
                });
            }
            finally {
                if (walk == null) continue;
                walk.close();
            }
        }
        for (CompletableFuture result : results) {
            try {
                List ret = (List)result.get();
                for (EntryResult entryResult : ret) {
                    cachedOutput.m_213871_(entryResult.path, entryResult.data, entryResult.hash);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<EntryResult> task(Path outPath, Path inPath, Path path) {
        JsonObject model;
        Path rp = inPath.relativize(path);
        Path op = outPath.resolve(rp);
        try (FileReader reader = new FileReader(path.toFile());
             BufferedReader bufReader = new BufferedReader(reader);){
            model = (JsonObject)GSON.fromJson((Reader)bufReader, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.divModel(FNStringUtil.removeExtension(op.toFile().getName()), model).entrySet().stream().map(ret -> {
            HashCode hashCode;
            byte[] bs;
            String name = (String)ret.getKey();
            JsonObject divModel = (JsonObject)ret.getValue();
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                 ByteArrayInputStream stream = new ByteArrayInputStream(GSON.toJson((JsonElement)divModel).getBytes(StandardCharsets.UTF_8));){
                FNDataUtil.i2o(stream, (OutputStream)hashingOutputStream);
                bs = byteArrayOutputStream.toByteArray();
                hashCode = hashingOutputStream.hash();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new EntryResult(op.getParent().resolve(FNStringUtil.escapeFileName(name, "_") + ".json"), bs, hashCode);
        }).toList();
    }

    protected Map<String, JsonObject> divModel(String name, JsonObject original) {
        return IntStream.range(0, 10).mapToObj(n -> Pair.of((Object)(name + "_" + n), (Object)original)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected boolean isChildDir(Path inputFolder, Path path, Path targetPath) {
        Path rp = inputFolder.relativize(path);
        String rps = rp.toString().replace("\\", "/");
        String tps = targetPath.toString().replace("\\", "/");
        return rps.startsWith(tps);
    }

    @Override
    public String getName() {
        return "Model Division";
    }

    private record EntryResult(Path path, byte[] data, HashCode hash) {
    }
}

