/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.shape;

import dev.felnull.otyacraftengine.client.shape.ClientIVShapeLoader;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import dev.felnull.otyacraftengine.explatform.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientIVShapeManager
extends SimplePreparableReloadListener<ClientIVShapeLoader> {
    private static final ClientIVShapeManager INSTANCE = OEClientExpectPlatform.createCIVSManagerInstance();
    private Map<ResourceLocation, VoxelClientShape> voxelClientShapes;
    private Map<ResourceLocation, VoxelClientShape> legacyVoxelClientShapes = new HashMap<ResourceLocation, VoxelClientShape>();

    public static ClientIVShapeManager getInstance() {
        return INSTANCE;
    }

    protected ClientIVShapeLoader prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        return new ClientIVShapeLoader(resourceManager, profilerFiller);
    }

    protected void apply(@NotNull ClientIVShapeLoader loader, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.voxelClientShapes = loader.getVoxelClientShapes();
    }

    @Nullable
    public VoxelClientShape getVoxelClientShape(@Nullable ResourceLocation location) {
        VoxelClientShape ret = this.voxelClientShapes.get(location);
        if (ret != null) {
            return ret;
        }
        return this.legacyVoxelClientShapes.get(location);
    }

    public void addLegacyShapes(ResourceLocation location, Set<VoxelEdge> edges) {
        this.legacyVoxelClientShapes.put(location, new VoxelClientShape(null, null, edges));
    }
}

