/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.tag;

import com.google.common.base.Suppliers;
import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class OEForgeItemTags {
    public static final Supplier<TagKey<Item>> BOOKS = OEForgeItemTags.bind("books");
    public static final Supplier<ManualTagHolder<Item>> RAW_MEATS = OEForgeItemTags.bind("raw_meats", tp -> tp.add((T[])new Item[]{Items.f_42485_, Items.f_42579_, Items.f_42581_, Items.f_42697_, Items.f_42658_}).addOptionalTag(OEForgeItemTags.fgLocation("raw_meat")), new Supplier[0]);
    public static final Supplier<ManualTagHolder<Item>> COOKED_MEATS = OEForgeItemTags.bind("cooked_meats", tp -> tp.add((T[])new Item[]{Items.f_42580_, Items.f_42486_, Items.f_42582_, Items.f_42659_, Items.f_42698_}).addOptionalTag(OEForgeItemTags.fgLocation("cooked_meat")), new Supplier[0]);
    public static final Supplier<ManualTagHolder<Item>> MEATS = OEForgeItemTags.bind("meats", tp -> tp.addTag(RAW_MEATS.get().getKey()).addTag(COOKED_MEATS.get().getKey()), RAW_MEATS, COOKED_MEATS);

    private static Supplier<TagKey<Item>> bind(String id) {
        return Suppliers.memoize(() -> ItemTags.create((ResourceLocation)OEForgeItemTags.fgLocation(id)));
    }

    private static Supplier<ManualTagHolder<Item>> bind(String id, Consumer<TagProviderWrapper.TagAppenderWrapper<Item>> tagRegister, Supplier<ManualTagHolder<Item>> ... prerequisite) {
        return Suppliers.memoize(() -> ManualTagHolder.of(ItemTags.create((ResourceLocation)OEForgeItemTags.fgLocation(id)), tagRegister, (ManualTagHolder[])Arrays.stream(prerequisite).map(Supplier::get).toArray(ManualTagHolder[]::new)));
    }

    private static ResourceLocation fgLocation(String path) {
        return new ResourceLocation("forge", path);
    }
}

