/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class FNArrayUtil {
    public static <T> T[] add(T[] array, T element) {
        T[] n = Arrays.copyOf(array, array.length + 1);
        n[array.length] = element;
        return n;
    }

    public static int[] add(int[] array, int value) {
        int[] n = Arrays.copyOf(array, array.length + 1);
        n[array.length] = value;
        return n;
    }

    public static float[] add(float[] array, float value) {
        float[] n = Arrays.copyOf(array, array.length + 1);
        n[array.length] = value;
        return n;
    }

    public static <T> T[] add(T[] array, T[] elements) {
        T[] n = Arrays.copyOf(array, array.length + elements.length);
        System.arraycopy(elements, 0, n, array.length, elements.length);
        return n;
    }

    public static int[] add(int[] array, int[] values) {
        int[] n = Arrays.copyOf(array, array.length + values.length);
        System.arraycopy(values, 0, n, array.length, values.length);
        return n;
    }

    public static float[] add(float[] array, float[] values) {
        float[] n = Arrays.copyOf(array, array.length + values.length);
        System.arraycopy(values, 0, n, array.length, values.length);
        return n;
    }

    public static <T> boolean contains(T[] array, T element) {
        for (T t : array) {
            if (!Objects.equals(t, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        for (int t : array) {
            if (value != t) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float[] array, float value) {
        for (float t : array) {
            if (value != t) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] insert(T[] array, int index, T element) {
        T[] n = Arrays.copyOf(array, array.length + 1);
        System.arraycopy(array, index, n, index + 1, array.length - index);
        n[index] = element;
        return n;
    }

    public static int[] insert(int[] array, int index, int value) {
        int[] n = new int[array.length + 1];
        System.arraycopy(array, 0, n, 0, index);
        System.arraycopy(array, index, n, index + 1, array.length - index);
        n[index] = value;
        return n;
    }

    public static float[] insert(float[] array, int index, float value) {
        float[] n = new float[array.length + 1];
        System.arraycopy(array, 0, n, 0, index);
        System.arraycopy(array, index, n, index + 1, array.length - index);
        n[index] = value;
        return n;
    }

    public static <T> T[] allGet(Class<T> clazz, Supplier<T>[] suppliers) {
        Object[] array = (Object[])Array.newInstance(clazz, suppliers.length);
        for (int i = 0; i < suppliers.length; ++i) {
            array[i] = suppliers[i].get();
        }
        return array;
    }
}

