package dev.felnull.otyacraftengine.forge.tag;

import com.google.common.base.Suppliers;
import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class OEForgeItemTags {
    public static final Supplier<TagKey<Item>> BOOKS = bind("books");
    public static final Supplier<ManualTagHolder<Item>> RAW_MEATS = bind("raw_meats", tp -> tp.add(Items.f_42485_, Items.f_42579_, Items.f_42581_, Items.f_42697_, Items.f_42658_).addOptionalTag(fgLoc("raw_meat")));
    public static final Supplier<ManualTagHolder<Item>> COOKED_MEATS = bind("cooked_meats", tp -> tp.add(Items.f_42580_, Items.f_42486_, Items.f_42582_, Items.f_42659_, Items.f_42698_).addOptionalTag(fgLoc("cooked_meat")));
    public static final Supplier<ManualTagHolder<Item>> RAW_FISHES = bind("raw_fishes", tp -> tp.add(Items.f_42526_, Items.f_42527_, Items.f_42528_));
    public static final Supplier<ManualTagHolder<Item>> COOKED_FISHES = bind("cooked_fishes", tp -> tp.add(Items.f_42530_, Items.f_42531_));
    public static final Supplier<ManualTagHolder<Item>> BREAD_WHEAT = bind("bread/wheat", tp -> tp.add(Items.f_42406_));
    public static final Supplier<ManualTagHolder<Item>> BREAD = bind("bread", tp -> tp.addTag(BREAD_WHEAT.get()));
    public static final Supplier<ManualTagHolder<Item>> VEGETABLES = bind("vegetables", tp -> tp.add(Items.f_42619_, Items.f_42620_, Items.f_42732_));
    public static final Supplier<ManualTagHolder<Item>> GRAINS_WHEAT = bind("grains/wheat", tp -> tp.add(Items.f_42405_).addOptionalTag(fgLoc("grain/wheat")));
    public static final Supplier<ManualTagHolder<Item>> GRAINS = bind("grain", tp -> tp.addTag(GRAINS_WHEAT.get()).addOptionalTag(fgLoc("grain")));
    public static final Supplier<ManualTagHolder<Item>> FRUITS = bind("fruits", tp -> tp.add(Items.f_42410_, Items.f_42028_, Items.f_42780_, Items.f_151079_, Items.f_42730_));
    public static final Supplier<ManualTagHolder<Item>> MILKS = bind("milks", tp -> tp.add(Items.f_42455_));
    public static final Supplier<ManualTagHolder<Item>> DRINKS = bind("drinks", tp -> tp.addOptionalTag(drinks()).addTag(MILKS.get()));

    private static Supplier<TagKey<Item>> bind(String id) {
        return Suppliers.memoize(() -> ItemTags.create(fgLoc(id)));
    }

    private static Supplier<ManualTagHolder<Item>> bind(String id, Consumer<TagProviderWrapper.TagAppenderWrapper<Item>> tagRegister) {
        return Suppliers.memoize(() -> ManualTagHolder.of(ItemTags.create(fgLoc(id)), tagRegister));
    }

    private static ResourceLocation fgLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private static ResourceLocation[] drinks() {
        return new ResourceLocation[]{fgLoc("juices"), fgLoc("banana_smoothies"), fgLoc("strawberry_smoothies"), fgLoc("coffees"), fgLoc("lemonades"), fgLoc("limeades"), fgLoc("kale_smoothies"), fgLoc("fruit_smoothies"), fgLoc("chocolate_milkshakes"), fgLoc("beers"), fgLoc("wines"), fgLoc("meads"), fgLoc("rums"), fgLoc("pumpkin_spice_lattes"), fgLoc("water_bottles"), fgLoc("milk_bottles"), fgLoc("tea")};
    }
}
