/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapper;
import java.util.ArrayList;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class BlockLootTableProviderWrapper
extends DataProviderWrapper<DataProvider> {
    private final DataProvider blockLootTableProvider;

    public BlockLootTableProviderWrapper(PackOutput packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.blockLootTableProvider = crossDataGeneratorAccess.createBlockLootTableProvider(packOutput, this);
    }

    @Override
    public DataProvider getProvider() {
        return this.blockLootTableProvider;
    }

    public abstract void generateBlockLootTables(BlockLootSubProvider var1, BlockLootTableProviderAccess var2);

    public abstract Iterable<Block> getKnownBlocks();

    protected Iterable<Block> extract(DeferredRegister<Block> deferredRegister) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        deferredRegister.iterator().forEachRemaining(r -> blocks.add((Block)r.get()));
        return blocks;
    }

    public static interface BlockLootTableProviderAccess {
        public void excludeFromStrictValidation(Block var1);

        public void dropSelf(Block var1);

        public void dropOther(Block var1, ItemLike var2);

        public void add(Block var1, LootTable.Builder var2);
    }
}

