/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.InputBaseProviderWrapper;
import dev.felnull.otyacraftengine.util.OEDataGenUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DirectCopyProviderWrapper
extends InputBaseProviderWrapper {
    public DirectCopyProviderWrapper(PackOutput packOutput, PackOutput.Target target, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, target, kind, crossDataGeneratorAccess);
    }

    public DirectCopyProviderWrapper(PackOutput packOutput, PackOutput.Target target, String modId, String kind, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, target, modId, kind, crossDataGeneratorAccess);
    }

    @Override
    @Nullable
    protected CompletableFuture<?> runTask(CachedOutput cachedOutput, Path inputRoot, Path target) {
        return CompletableFuture.runAsync(() -> {
            Pair<ResourceLocation, String> locEx = this.toResourceLocationAndExtension(inputRoot, target);
            try (FileInputStream stream = new FileInputStream(target.toFile());
                 BufferedInputStream bufStream = new BufferedInputStream(stream);){
                OEDataGenUtils.save(cachedOutput, bufStream, this.pathProvider.m_245527_((ResourceLocation)locEx.getKey(), (String)locEx.getValue()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Util.m_183991_());
    }

    @Override
    protected boolean isTarget(Path rootPath, Path targetPath) {
        return true;
    }

    @Override
    public String getName() {
        return "Input copy";
    }
}

