/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data.provider;

import dev.felnull.otyacraftengine.data.model.BlockStateAndModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import dev.felnull.otyacraftengine.data.provider.BlockStateAndModelProviderWrapper;
import dev.felnull.otyacraftengine.forge.data.WrappedBlockStateBuilder;
import dev.felnull.otyacraftengine.forge.data.model.BlockMutableFileModelImpl;
import dev.felnull.otyacraftengine.forge.data.model.FileModelImpl;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WrappedBlockStateProvider
extends BlockStateProvider {
    private final BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper;

    public WrappedBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper, BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper) {
        super(output, modid, exFileHelper);
        this.blockStateAndModelProviderWrapper = blockStateAndModelProviderWrapper;
    }

    protected void registerStatesAndModels() {
        this.blockStateAndModelProviderWrapper.generateStatesAndModels(new BlockStateAndModelProviderAccessImpl());
    }

    private class BlockStateAndModelProviderAccessImpl
    implements BlockStateAndModelProviderAccess {
        private BlockStateAndModelProviderAccessImpl() {
        }

        @Override
        public void simpleCubeBlockStateModelAndItemModel(@NotNull Block block) {
            ModelFile model = WrappedBlockStateProvider.this.cubeAll(block);
            WrappedBlockStateProvider.this.simpleBlock(block, model);
            WrappedBlockStateProvider.this.simpleBlockItem(block, model);
        }

        private FileModel of(ModelFile modelFile) {
            return new FileModelImpl(modelFile);
        }

        private MutableFileModel of(BlockModelBuilder blockModelBuilder) {
            return new BlockMutableFileModelImpl(blockModelBuilder);
        }

        @Override
        @NotNull
        public FileModel cubeAllBlockModel(@NotNull String fileName, @NotNull ResourceLocation texture) {
            return this.of((BlockModelBuilder)WrappedBlockStateProvider.this.models().cubeAll(fileName, texture));
        }

        @Override
        @NotNull
        public FileModel cubeBlockModel(@NotNull String fileName, @NotNull ResourceLocation down, @NotNull ResourceLocation up, @NotNull ResourceLocation north, @NotNull ResourceLocation south, @NotNull ResourceLocation east, @NotNull ResourceLocation west) {
            return this.of((BlockModelBuilder)WrappedBlockStateProvider.this.models().cube(fileName, down, up, north, south, east, west));
        }

        @Override
        @NotNull
        public MutableFileModel parentedBlockModel(@NotNull Block block, @NotNull ResourceLocation parentLocation) {
            return this.of((BlockModelBuilder)WrappedBlockStateProvider.this.models().withExistingParent(this.name(block), parentLocation));
        }

        @Override
        @NotNull
        public FileModel existingModel(@NotNull ResourceLocation location) {
            return this.of((ModelFile)WrappedBlockStateProvider.this.models().getExistingFile(location));
        }

        @Override
        @NotNull
        public FileModel particleOnlyModel(@NotNull Block block, @NotNull ResourceLocation particleLocation) {
            return this.of((BlockModelBuilder)((BlockModelBuilder)WrappedBlockStateProvider.this.models().getBuilder(this.name(block))).texture("particle", particleLocation));
        }

        @Override
        public void simpleBlockState(@NotNull Block block, @NotNull FileModel model) {
            WrappedBlockStateProvider.this.simpleBlock(block, FileModelImpl.getModelFile(model));
        }

        @Override
        public void simpleBlockItemModel(@NotNull Block block, @NotNull FileModel model) {
            WrappedBlockStateProvider.this.simpleBlockItem(block, FileModelImpl.getModelFile(model));
        }

        @Override
        public void horizontalBlockState(@NotNull Block block, @NotNull FileModel model) {
            WrappedBlockStateProvider.this.horizontalBlock(block, FileModelImpl.getModelFile(model));
        }

        @Override
        public void parentedBlockItemModel(@NotNull Block block, @NotNull ResourceLocation parentLocation) {
            ResourceLocation name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()));
            ((ItemModelBuilder)WrappedBlockStateProvider.this.itemModels().getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(parentLocation));
        }

        @Override
        public void addBlockStateGenerator(@NotNull BlockStateGenerator blockStateGenerator) {
            Block block = blockStateGenerator.m_6968_();
            if (WrappedBlockStateProvider.this.registeredBlocks.containsKey(block)) {
                throw new IllegalStateException("Duplicate registration");
            }
            WrappedBlockStateProvider.this.registeredBlocks.put(block, new WrappedBlockStateBuilder(blockStateGenerator));
        }

        private String name(Block block) {
            return this.key(block).m_135815_();
        }

        private ResourceLocation key(Block block) {
            return ForgeRegistries.BLOCKS.getKey((Object)block);
        }
    }
}

