/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data.provider;

import dev.felnull.otyacraftengine.data.model.ItemModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import dev.felnull.otyacraftengine.data.provider.ItemModelProviderWrapper;
import dev.felnull.otyacraftengine.forge.data.model.ItemMutableFileModelImpl;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WrappedItemModelProvider
extends ItemModelProvider {
    private final ItemModelProviderWrapper itemModelProviderWrapper;

    public WrappedItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper, ItemModelProviderWrapper itemModelProviderWrapper) {
        super(output, modid, existingFileHelper);
        this.itemModelProviderWrapper = itemModelProviderWrapper;
    }

    protected void registerModels() {
        this.itemModelProviderWrapper.generateItemModels(new ItemModelProviderAccessImpl());
    }

    private class ItemModelProviderAccessImpl
    implements ItemModelProviderAccess {
        private ItemModelProviderAccessImpl() {
        }

        private MutableFileModel of(ItemModelBuilder itemModelBuilder) {
            return new ItemMutableFileModelImpl(itemModelBuilder);
        }

        @Override
        @NotNull
        public MutableFileModel basicFlatItem(@NotNull Item item) {
            return this.of(WrappedItemModelProvider.this.basicItem(item));
        }

        @Override
        @NotNull
        public MutableFileModel basicFlatItem(@NotNull ResourceLocation itemLocation) {
            return this.of(WrappedItemModelProvider.this.basicItem(itemLocation));
        }

        @Override
        @NotNull
        public MutableFileModel handheldFlatItem(@NotNull Item item) {
            return this.handheldFlatItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
        }

        @Override
        @NotNull
        public MutableFileModel handheldFlatItem(@NotNull ResourceLocation itemLocation) {
            return this.of((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)WrappedItemModelProvider.this.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", new ResourceLocation(itemLocation.m_135827_(), "item/" + itemLocation.m_135815_())));
        }

        @Override
        @NotNull
        public MutableFileModel builtinEntityItem(@NotNull Item item) {
            return this.builtinEntityItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
        }

        @Override
        @NotNull
        public MutableFileModel builtinEntityItem(@NotNull ResourceLocation itemLocation) {
            return this.of((ItemModelBuilder)((ItemModelBuilder)WrappedItemModelProvider.this.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity")));
        }

        @Override
        @NotNull
        public MutableFileModel parentedItem(@NotNull Item item, @NotNull ResourceLocation parentLocation) {
            return this.parentedItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)), parentLocation);
        }

        @Override
        @NotNull
        public MutableFileModel parentedItem(@NotNull ResourceLocation itemLocation, @NotNull ResourceLocation parentLocation) {
            return this.of((ItemModelBuilder)((ItemModelBuilder)WrappedItemModelProvider.this.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(parentLocation)));
        }
    }
}

