/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.tag;

import com.google.common.base.Suppliers;
import dev.felnull.otyacraftengine.data.provider.IntrinsicHolderTagsProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class OEForgeItemTags {
    public static final Supplier<TagKey<Item>> BOOKS = OEForgeItemTags.bind("books");
    public static final Supplier<ManualTagHolder<Item>> RAW_MEATS = OEForgeItemTags.bind("raw_meats", tp -> tp.add((T[])new Item[]{Items.f_42485_, Items.f_42579_, Items.f_42581_, Items.f_42697_, Items.f_42658_}).addOptionalTag(OEForgeItemTags.fgLoc("raw_meat")));
    public static final Supplier<ManualTagHolder<Item>> COOKED_MEATS = OEForgeItemTags.bind("cooked_meats", tp -> tp.add((T[])new Item[]{Items.f_42580_, Items.f_42486_, Items.f_42582_, Items.f_42659_, Items.f_42698_}).addOptionalTag(OEForgeItemTags.fgLoc("cooked_meat")));
    public static final Supplier<ManualTagHolder<Item>> RAW_FISHES = OEForgeItemTags.bind("raw_fishes", tp -> tp.add((T[])new Item[]{Items.f_42526_, Items.f_42527_, Items.f_42528_}));
    public static final Supplier<ManualTagHolder<Item>> COOKED_FISHES = OEForgeItemTags.bind("cooked_fishes", tp -> tp.add((T[])new Item[]{Items.f_42530_, Items.f_42531_}));
    public static final Supplier<ManualTagHolder<Item>> BREAD_WHEAT = OEForgeItemTags.bind("bread/wheat", tp -> tp.add(Items.f_42406_));
    public static final Supplier<ManualTagHolder<Item>> BREAD = OEForgeItemTags.bind("bread", tp -> tp.addTagHolder(BREAD_WHEAT.get()));
    public static final Supplier<ManualTagHolder<Item>> VEGETABLES = OEForgeItemTags.bind("vegetables", tp -> tp.add((T[])new Item[]{Items.f_42619_, Items.f_42620_, Items.f_42732_}));
    public static final Supplier<ManualTagHolder<Item>> GRAINS_WHEAT = OEForgeItemTags.bind("grains/wheat", tp -> tp.add(Items.f_42405_).addOptionalTag(OEForgeItemTags.fgLoc("grain/wheat")));
    public static final Supplier<ManualTagHolder<Item>> GRAINS = OEForgeItemTags.bind("grain", tp -> tp.addTagHolder(GRAINS_WHEAT.get()).addOptionalTag(OEForgeItemTags.fgLoc("grain")));
    public static final Supplier<ManualTagHolder<Item>> FRUITS = OEForgeItemTags.bind("fruits", tp -> tp.add((T[])new Item[]{Items.f_42410_, Items.f_42028_, Items.f_42780_, Items.f_151079_, Items.f_42730_}));
    public static final Supplier<ManualTagHolder<Item>> MILKS = OEForgeItemTags.bind("milks", tp -> tp.add(Items.f_42455_));
    public static final Supplier<ManualTagHolder<Item>> DRINKS = OEForgeItemTags.bind("drinks", tp -> tp.addOptionalTag(OEForgeItemTags.drinks()).addTagHolder(MILKS.get()));

    private static Supplier<TagKey<Item>> bind(String id) {
        return Suppliers.memoize(() -> ItemTags.create((ResourceLocation)OEForgeItemTags.fgLoc(id)));
    }

    private static Supplier<ManualTagHolder<Item>> bind(String id, Consumer<IntrinsicHolderTagsProviderWrapper.IntrinsicTagAppenderWrapper<Item>> tagRegister) {
        return Suppliers.memoize(() -> ManualTagHolder.of(ItemTags.create((ResourceLocation)OEForgeItemTags.fgLoc(id)), tagRegister));
    }

    private static ResourceLocation fgLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private static ResourceLocation[] drinks() {
        return new ResourceLocation[]{OEForgeItemTags.fgLoc("juices"), OEForgeItemTags.fgLoc("banana_smoothies"), OEForgeItemTags.fgLoc("strawberry_smoothies"), OEForgeItemTags.fgLoc("coffees"), OEForgeItemTags.fgLoc("lemonades"), OEForgeItemTags.fgLoc("limeades"), OEForgeItemTags.fgLoc("kale_smoothies"), OEForgeItemTags.fgLoc("fruit_smoothies"), OEForgeItemTags.fgLoc("chocolate_milkshakes"), OEForgeItemTags.fgLoc("beers"), OEForgeItemTags.fgLoc("wines"), OEForgeItemTags.fgLoc("meads"), OEForgeItemTags.fgLoc("rums"), OEForgeItemTags.fgLoc("pumpkin_spice_lattes"), OEForgeItemTags.fgLoc("milk_bottles"), OEForgeItemTags.fgLoc("tea")};
    }
}

