package dev.felnull.otyacraftengine.client.renderer.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;

import java.io.IOException;

public class OEShaders {
    private static ShaderInstance RENDERTYPE_SIMPLE_SPRITE_SOLID_SHADER;
    private static ShaderInstance RENDERTYPE_SIMPLE_SPRITE_CUTOUT_SHADER;
    private static ShaderInstance RENDERTYPE_WAVE;

    public static void reload(ResourceProvider provider, ClientReloadShadersEvent.ShadersSink sink) throws IOException {

        sink.registerShader(new ShaderInstance(provider, OtyacraftEngine.MODID + "_rendertype_simple_sprite_solid", DefaultVertexFormat.f_85812_), shaderInstance -> {
            RENDERTYPE_SIMPLE_SPRITE_SOLID_SHADER = shaderInstance;
        });
        sink.registerShader(new ShaderInstance(provider, OtyacraftEngine.MODID + "_rendertype_simple_sprite_cutout", DefaultVertexFormat.f_85812_), shaderInstance -> {
            RENDERTYPE_SIMPLE_SPRITE_CUTOUT_SHADER = shaderInstance;
        });
        sink.registerShader(new ShaderInstance(provider, OtyacraftEngine.MODID + "_rendertype_wave", DefaultVertexFormat.f_85812_), shaderInstance -> {
            RENDERTYPE_WAVE = shaderInstance;
        });
    }

    public static ShaderInstance getRendertypeSimpleSpriteSolidShader() {
        return RENDERTYPE_SIMPLE_SPRITE_SOLID_SHADER;
    }

    public static ShaderInstance getRendertypeSimpleSpriteCutoutShader() {
        return RENDERTYPE_SIMPLE_SPRITE_CUTOUT_SHADER;
    }

    public static ShaderInstance getRendertypeWave() {
        return RENDERTYPE_WAVE;
    }
}
