package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.model.BlockStateAndModelProviderAccess;
import net.minecraft.core.Direction;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public abstract class BlockStateAndModelProviderWrapper extends DataProviderWrapper<DataProvider> {
    public static final ResourceLocation OE_BASE_BLOCK_ENTITY_MODEL = new ResourceLocation(OtyacraftEngine.MODID, "base/block_entity");
    public static final ResourceLocation OE_BASE_BLOCK_ENTITY_APPEARANCE_MODEL = new ResourceLocation(OtyacraftEngine.MODID, "base/block_entity_appearance");
    private final DataProvider blockStateAndModelProvider;

    public BlockStateAndModelProviderWrapper(PackOutput packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.blockStateAndModelProvider = crossDataGeneratorAccess.createBlockStateAndModelProvider(packOutput, this);
    }

    @Override
    public DataProvider getProvider() {
        return blockStateAndModelProvider;
    }

    public abstract void generateStatesAndModels(BlockStateAndModelProviderAccess providerAccess);

    /**
     * BlockModelGenerators$createHorizontalFacingDispatchの移植
     *
     * @return PropertyDispatch
     */
    public PropertyDispatch createHorizontalFacingDispatch() {
        return PropertyDispatch.m_125294_(BlockStateProperties.f_61374_)
                .m_125329_(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, VariantProperties.Rotation.R90))
                .m_125329_(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, VariantProperties.Rotation.R180))
                .m_125329_(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, VariantProperties.Rotation.R270))
                .m_125329_(Direction.NORTH, Variant.m_125501_());
    }

    /**
     * BlockModelGenerators$createBooleanModelDispatchの移植
     *
     * @return PropertyDispatch
     */
    public PropertyDispatch createBooleanModelDispatch(BooleanProperty booleanProperty, ResourceLocation trueLoc, ResourceLocation falseLoc) {
        return PropertyDispatch.m_125294_(booleanProperty)
                .m_125329_(true, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, trueLoc))
                .m_125329_(false, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, falseLoc));
    }
}
