/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.entity.PlayerNameByUUIDResult;
import dev.felnull.otyacraftengine.client.entity.PlayerUUIDByNameResult;
import dev.felnull.otyacraftengine.explatform.client.OEClientExpectPlatform;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class OEClientUtils {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static float getParSecond(long loopTime) {
        return (float)(System.currentTimeMillis() % loopTime) / (float)loopTime;
    }

    public static InputConstants.Key getKey(@NotNull KeyMapping keyMapping) {
        return OEClientExpectPlatform.getKey(keyMapping);
    }

    @NotNull
    public static GameProfile getPlayerLackProfileTolerance(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getLackProfileTolerance(name);
    }

    @NotNull
    public static Optional<UUID> getPlayerUUIDByName(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByName(name);
    }

    @NotNull
    public static CompletableFuture<Optional<UUID>> getPlayerUUIDByNameAsync(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByNameAsync(name);
    }

    @NotNull
    public static Optional<String> getPlayerNameByUUID(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUID(uuid);
    }

    @NotNull
    public static CompletableFuture<Optional<String>> getPlayerNameByUUIDAsync(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUIDAsync(uuid);
    }

    @NotNull
    public PlayerUUIDByNameResult getPlayerUUIDByNameTolerance(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByNameTolerance(name);
    }

    @NotNull
    public PlayerNameByUUIDResult getPlayerNameByUUIDTolerance(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUIDTolerance(uuid);
    }

    public static boolean isKeyInput(int keyCode) {
        if (keyCode < 0) {
            return false;
        }
        long winID = Minecraft.m_91087_().m_91268_().m_85439_();
        if (keyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)winID, (int)keyCode) == 1;
        }
        return InputConstants.m_84830_((long)winID, (int)keyCode);
    }

    public static boolean isKeyInput(@NotNull KeyMapping keyMapping) {
        return OEClientUtils.isKeyInput(OEClientUtils.getKey(keyMapping).m_84873_());
    }

    public static double getMouseX() {
        return OEClientUtils.mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
    }

    public static double getMouseY() {
        return OEClientUtils.mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
    }

    @Nullable
    public static File[] openFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects) {
        return OEClientUtils.openFilterFileChooser(title, defaultPath, singleFilter, allowMultipleSelects, new String[0]);
    }

    @Nullable
    public static File[] openFilterFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects, String ... filterPatterns) {
        String ret;
        if (filterPatterns == null || filterPatterns.length == 0) {
            ret = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), null, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer patterns = stack.mallocPointer(filterPatterns.length);
                for (String filterPattern : filterPatterns) {
                    if (filterPattern == null) continue;
                    patterns.put(stack.UTF8((CharSequence)filterPattern));
                }
                patterns.flip();
                ret = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), (PointerBuffer)patterns, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
            }
        }
        if (ret == null) {
            return null;
        }
        try {
            if (allowMultipleSelects) {
                String[] sp = ret.split("\\|");
                File[] fl = new File[sp.length];
                for (int i = 0; i < sp.length; ++i) {
                    fl[i] = new File(sp[i]);
                }
                return fl;
            }
            return new File[]{new File(ret)};
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getWidthOmitText(String text, float maxWidth, String exit) {
        int wh = OEClientUtils.mc.f_91062_.m_92895_(text);
        if ((float)wh > maxWidth) {
            int exwh = OEClientUtils.mc.f_91062_.m_92895_(exit);
            StringBuilder sb = new StringBuilder();
            for (char c : text.toCharArray()) {
                sb.append(c);
                if ((float)OEClientUtils.mc.f_91062_.m_92895_(sb.toString()) > maxWidth - (float)exwh) break;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(exit);
            return sb.toString();
        }
        return text;
    }
}

