/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.AdvancementProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.AdvancementSubProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BasicProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockLootTableProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockStateAndModelProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.FluidTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemModelProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.PoiTypeTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedAdvancementProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBasicProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBlockLootTableProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBlockStateProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBlockTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedFluidTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedItemModelProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedItemTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedPoiTypeTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedRecipeProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CrossDataGeneratorAccessImpl
implements CrossDataGeneratorAccess {
    private final List<Path> resourceInputFolders = new ArrayList<Path>();
    private final GatherDataEvent gatherDataEvent;

    protected CrossDataGeneratorAccessImpl(GatherDataEvent gatherDataEvent) {
        this.gatherDataEvent = gatherDataEvent;
    }

    @Override
    @NotNull
    public DataGenerator getVanillaGenerator() {
        return this.gatherDataEvent.getGenerator();
    }

    @Override
    public <T extends DataProvider> T addProvider(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull DataProvider.Factory<T> factory) {
        return (T)this.getVanillaGenerator().addProvider(true, factory);
    }

    @Override
    public <T extends DataProvider> T addProvider(@NotNull BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> dataProviderSupplier) {
        CompletableFuture lookup = this.gatherDataEvent.getLookupProvider();
        return (T)this.getVanillaGenerator().addProvider(true, arg -> (DataProvider)dataProviderSupplier.apply(arg, lookup));
    }

    @Override
    public Mod getMod() {
        return Platform.getMod((String)this.gatherDataEvent.getModContainer().getModId());
    }

    @Override
    public RecipeProvider createRecipeProvider(PackOutput packOutput, RecipeProviderWrapper recipeProviderWrapper) {
        return new WrappedRecipeProvider(packOutput, recipeProviderWrapper);
    }

    @Override
    public TagsProvider<Item> createItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper) {
        TagsProvider<Block> tagsProvider = blockTagProviderWrapper.getProvider();
        if (!(tagsProvider instanceof BlockTagsProvider)) {
            throw new IllegalArgumentException("Not BlockTagsProvider");
        }
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)tagsProvider;
        return new WrappedItemTagsProvider(packOutput, lookup, blockTagsProvider.m_274426_(), this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), itemTagProviderWrapper);
    }

    @Override
    public TagsProvider<Fluid> createFluidTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, FluidTagProviderWrapper fluidTagProviderWrapper) {
        return new WrappedFluidTagsProvider(packOutput, lookup, fluidTagProviderWrapper, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper());
    }

    @Override
    public TagsProvider<Block> createBlockTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, BlockTagProviderWrapper blockTagProviderWrapper) {
        return new WrappedBlockTagsProvider(packOutput, lookup, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), blockTagProviderWrapper);
    }

    @Override
    public TagsProvider<PoiType> createPoiTypeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, PoiTypeTagProviderWrapper poiTypeTagProviderWrapper) {
        return new WrappedPoiTypeTagsProvider(packOutput, lookup, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), poiTypeTagProviderWrapper);
    }

    @Override
    public DataProvider createBasicProvider(BasicProviderWrapper basicProviderWrapper) {
        return new WrappedBasicProvider(basicProviderWrapper);
    }

    @Override
    public DataProvider createBlockLootTableProvider(PackOutput packOutput, BlockLootTableProviderWrapper blockLootTableProviderWrapper) {
        return new WrappedBlockLootTableProvider(packOutput, blockLootTableProviderWrapper);
    }

    @Override
    public DataProvider createAdvancementProvider(PackOutput packOutput, AdvancementProviderWrapper advancementProviderWrapper, List<AdvancementSubProviderWrapper> subProviderWrappers) {
        return new WrappedAdvancementProvider(this.getVanillaGenerator().getPackOutput(), this.gatherDataEvent.getLookupProvider(), subProviderWrappers, advancementProviderWrapper);
    }

    @Override
    public DataProvider createItemModelProvider(PackOutput packOutput, ItemModelProviderWrapper itemModelProviderWrapper) {
        return new WrappedItemModelProvider(packOutput, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), itemModelProviderWrapper);
    }

    @Override
    public DataProvider createBlockStateAndModelProvider(PackOutput packOutput, BlockStateAndModelProviderWrapper blockStateAndModelProviderWrapper) {
        return new WrappedBlockStateProvider(packOutput, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), blockStateAndModelProviderWrapper);
    }

    @Override
    public RegistriesDatapackGenerator createRegistriesDatapackGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, RegistrySetBuilder registrySetBuilder) {
        return new DatapackBuiltinEntriesProvider(packOutput, lookup, registrySetBuilder, (Set)ImmutableSet.of((Object)this.gatherDataEvent.getModContainer().getModId()));
    }

    @Override
    public Collection<Path> getResourceInputFolders() {
        return ImmutableList.copyOf(this.resourceInputFolders);
    }

    @Override
    public void addResourceInputFolders(Path path) {
        this.resourceInputFolders.add(path);
    }
}

