package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBasedButton;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SwitchButton extends OEBasedButton {
    private final boolean showLabel;
    private boolean enable;

    public SwitchButton(int x, int y, @NotNull Component message, boolean showLabel) {
        this(x, y, message, TextureRegion.relative(OE_WIDGETS, 40, 0, 40, 34), showLabel);
    }

    public SwitchButton(int x, int y, @NotNull Component message, @NotNull TextureRegion texture, boolean showLabel) {
        super(x, y, 20, 10, message, "switchButton", texture);
        this.showLabel = showLabel;
    }

    @Override
    public void m_5691_() {
        this.enable = !this.enable;
    }


    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mx, int my, float delta) {
        PoseStack poseStack = guiGraphics.m_280168_();

        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShaderTexture(0, getTexture().location());
        RenderSystem.enableDepthTest();
        Font font = minecraft.f_91062_;
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.f_93625_);
        OERenderUtils.blitFloat(poseStack, m_252754_(), m_252907_(), getTexture().u0() + (this.m_198029_() ? 20 : 0), getTexture().v0() + (this.enable ? 10 : 0), 20, 10, getTexture().width(), getTexture().height());
        OERenderUtils.blitFloat(poseStack, m_252754_() + (this.enable ? (f_93618_ - 8) : 0), m_252907_() - 2, getTexture().u0() + (this.m_198029_() ? 8 : 0), getTexture().v0() + 20, 8, 14, getTexture().width(), getTexture().height());

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        if (this.showLabel) {
            //   drawString(poseStack, font, this.getMessage(), this.getX() + 24, this.getY() + (this.height - 8) / 2, 14737632 | Mth.ceil(this.alpha * 255.0F) << 24);
            guiGraphics.m_280430_(font, this.m_6035_(), this.m_252754_() + 24, this.m_252907_() + (this.f_93619_ - 8) / 2, 14737632 | Mth.m_14167_(this.f_93625_ * 255.0F) << 24);
        }
    }

    public boolean isEnable() {
        return enable;
    }
}
