package dev.felnull.otyacraftengine.client.renderer.texture;

import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.blaze3d.platform.NativeImage;
import dev.felnull.fnjl.util.FNImageUtil;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public final class DynamicGifTexture extends DynamicTexture implements Tickable {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    private DynamicGifTexture(long duration, ImageFrame... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    @Override
    public void m_7673_() {
        int ct = Math.toIntExact(getFrameByTime(System.currentTimeMillis() % duration));
        if (ct != last) {
            this.f_117977_ = frames[ct].image();
            m_117985_();
            last = ct;
        }
    }

    private int getFrameByTime(long time) {
        return Mth.m_14049_(0, frames.length, v -> time <= frames[v].timestamp());
    }

    @Override
    public void close() {
        super.close();
        if (frames != null) {
            for (ImageFrame image : frames) {
                if (image != null)
                    image.image().close();
            }
        }
    }

    @NotNull
    public static DynamicGifTexture create(@NotNull GifDecoder decoder, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        ImageFrame[] frames = new ImageFrame[decoder.getFrameCount()];
        if (progress != null)
            progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), 0));
        long duration = 0;
        for (int i = 0; i < decoder.getFrameCount(); i++) {
            if (progress != null)
                progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), i + 1));
            var img = decoder.getFrame(i);
            long delay = decoder.getDelay(i);
            duration += delay;
            try (var stream = FNImageUtil.toInputStream(img, "png")) {
                frames[i] = new ImageFrame(NativeImage.m_85058_(stream), duration);
            }
        }
        return new DynamicGifTexture(duration, frames);
    }

    private static record ImageFrame(NativeImage image, long timestamp) {
    }
}
