package dev.felnull.otyacraftengine.item;

import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

import java.util.function.Function;

public class ItemContainer implements Container {
    private final ItemStack itemStack;
    private final PlayerItemLocation location;
    private final NonNullList<ItemStack> items;
    private final String tagName;
    private final Function<Player, Boolean> valid;

    public ItemContainer(ItemStack itemStack, PlayerItemLocation location, int size, String tagName, Function<Player, Boolean> valid) {
        this.itemStack = itemStack;
        this.items = NonNullList.m_122780_(size, ItemStack.f_41583_);
        this.location = location;
        loadItemList(itemStack, items, tagName);
        this.tagName = tagName;
        this.valid = valid;
    }

    @Override
    public int m_6643_() {
        return this.items.size();
    }

    @Override
    public boolean m_7983_() {
        return items.stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public ItemStack m_8020_(int i) {
        return items.get(i);
    }

    @Override
    public ItemStack m_7407_(int i, int j) {
        var ret = ContainerHelper.m_18969_(items, i, j);
        saveItems();
        return ret;
    }

    @Override
    public ItemStack m_8016_(int i) {
        var ret = ContainerHelper.m_18966_(items, i);
        saveItems();
        return ret;
    }

    @Override
    public void m_6836_(int i, ItemStack stack) {
        ItemStack itemstack = items.get(i);
        /* boolean flag = !stack.isEmpty() && stack.sameItem(itemstack) && ItemStack.tagMatches(stack, itemstack);*/
        items.set(i, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
//        if (flag)
        this.m_6596_();
    }

    public Function<Player, Boolean> getValid() {
        return valid;
    }

    public String getTagName() {
        return tagName;
    }

    @Override
    public void m_6596_() {
        saveItems();
    }

    @Override
    public boolean m_6542_(Player player) {
        return !itemStack.m_41619_() && valid.apply(player) && location.getItem(player) == itemStack;
    }

    @Override
    public void m_6211_() {
        items.clear();
    }

    @Override
    public void m_5785_(Player player) {
        Container.super.m_5785_(player);
        saveItems();
    }

    public NonNullList<ItemStack> getItems() {
        return items;
    }

    public PlayerItemLocation getLocation() {
        return location;
    }

    public void saveItems() {
        saveItemList(itemStack, items, tagName);
    }

    public static void loadItemList(ItemStack itemStack, NonNullList<ItemStack> items, String tagName) {
        var tag = itemStack.m_41783_();
        if (tag != null)
            ContainerHelper.m_18980_(tag.m_128469_(tagName), items);
    }

    public static void saveItemList(ItemStack itemStack, NonNullList<ItemStack> items, String tagName) {
        var tag = itemStack.m_41784_();
        if (!tag.m_128441_(tagName))
            tag.m_128365_(tagName, new CompoundTag());
        ContainerHelper.m_18973_(tag.m_128469_(tagName), items);
    }

    public ItemStack getItemStack() {
        return itemStack;
    }

    public static MenuProvider createMenuProvider(ItemStack stack, PlayerItemLocation location, int size, String tagName, MenuFactory factory) {
        var con = new ItemContainer(stack, location, size, tagName, player -> {
            if (location.getItem(player).m_41619_() || stack.m_41619_())
                return false;
            return location.getItem(player) == stack;
        });
        return new SimpleMenuProvider((i, inventory, player1) -> factory.createMenu(i, inventory, con, BlockPos.f_121853_, stack, location), stack.m_41786_());
    }

    public static interface MenuFactory {
        AbstractContainerMenu createMenu(int i, Inventory playerInventory, Container container, BlockPos pos, ItemStack itemStack, PlayerItemLocation location);
    }
}
