package dev.felnull.otyacraftengine.client.gui.screen;


import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.inventory.OEBaseMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

import java.util.UUID;

public abstract class OEContainerBasedScreen<T extends OEBaseMenu> extends AbstractContainerScreen<T> implements InstructionScreen, OEBaseScreen {
    protected static final Minecraft mc = Minecraft.m_91087_();
    protected final UUID id = UUID.randomUUID();
    protected int bgTextureWidth = 256;
    protected int bgTextureHeight = 256;

    public OEContainerBasedScreen(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }


    @Override
    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, i, j, f);
        this.m_280072_(guiGraphics, i, j);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        if (getBackGrandTexture() != null) {
           /* RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
            RenderSystem.setShaderTexture(0, getBackGrandTexture());
          blit(poseStack, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight, bgTextureWidth, bgTextureHeight);*/
            guiGraphics.m_280163_(getBackGrandTexture(), f_97735_, f_97736_, 0, 0, this.f_97726_, this.f_97727_, bgTextureWidth, bgTextureHeight);
        }
    }

    protected abstract ResourceLocation getBackGrandTexture();


    @Override
    public boolean m_7979_(double d, double e, int i, double f, double g) {
        boolean flag1 = super.m_7979_(d, e, i, f, g);
        boolean flag2 = this.m_7222_() != null && this.m_7282_() && i == 0 && this.m_7222_().m_7979_(d, e, i, f, g);
        return flag1 & flag2;
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        for (GuiEventListener child : m_6702_()) {
            if (child instanceof EditBox editBox) {
                editBox.m_94120_();
            }
        }
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (i == 256)
            mc.f_91074_.m_6915_();

        for (GuiEventListener child : m_6702_()) {
            if (child instanceof EditBox editBox) {
                if (editBox.m_7933_(i, j, k) || editBox.m_94204_())
                    return true;
            }
        }

        return super.m_7933_(i, j, k);
    }

    @Override
    public void onInstructionReturn(String name, CompoundTag data) {

    }

    @Override
    public UUID getInstructionID() {
        return id;
    }
}