package dev.felnull.otyacraftengine.client.gui.screen;


import dev.felnull.otyacraftengine.inventory.OEItemBEBaseMenu;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class OEItemBEContainerBasedScreen<T extends OEItemBEBaseMenu> extends OEContainerBasedScreen<T> implements InstructionItemScreen, InstructionBEScreen {

    public OEItemBEContainerBasedScreen(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    public BlockEntity getBlockEntity() {
        return mc.f_91073_.m_7702_(getBlockPos());
    }

    public boolean isBlock() {
        return m_6262_().isBlock();
    }

    public ItemStack getItem() {
        return m_6262_().getItemStack(mc.f_91074_);
    }

    public BlockPos getBlockPos() {
        return m_6262_().getPos();
    }

    public PlayerItemLocation getItemLocation() {
        return f_97732_.getLocation();
    }

    @Override
    public void instruction(String name, CompoundTag data) {
        if (isBlock()) {
            InstructionBEScreen.instructionBlockEntity(this, getBlockEntity(), name, data);
        } else {
            InstructionItemScreen.instructionItem(this, getItem(), getItemLocation(), name, data);
        }
    }
}