package dev.felnull.otyacraftengine.mixin.client;

import ;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.PoseStack.Pose;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType.HighlightVoxelShapeGetter;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeManager;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import dev.felnull.otyacraftengine.shape.VoxelPose;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;


@Mixin(LevelRenderer.class)
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method = "renderHitOutline", at = @At("HEAD"), cancellable = true)
    private void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, double d, double e, double f, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        var shapeType = OtyacraftEngineClientDebug.getInstance().getHighlightVoxelShape();
        if (shapeType != HighlightVoxelShapeType.OFF) {
            var shape = shapeType.getGetter();
            if (shape != null)
                LevelRenderer.m_285900_(poseStack, vertexConsumer, shape.getShape(blockState, level, blockPos, CollisionContext.m_82750_(entity)), (double) blockPos.m_123341_() - d, (double) blockPos.m_123342_() - e, (double) blockPos.m_123343_() - f, 0.0F, 0.0F, 0.0F, 0.4F, true);
            ci.cancel();
        }
    }

    @Inject(method = "renderShape", at = @At("HEAD"), cancellable = true)
    private static void renderShape(PoseStack poseStack, VertexConsumer vertexConsumer, VoxelShape voxelShape, double x, double y, double z, float r, float g, float b, float a, CallbackInfo ci) {
        if (((IkisugiVoxelShape) voxelShape).getRenderEdges() == null) return;
        ci.cancel();

        for (VoxelEntry entry : ((IkisugiVoxelShape) voxelShape).getRenderEdges()) {
            var cls = ClientIVShapeManager.getInstance().getVoxelClientShape(entry.getLocation());
            if (cls == null) continue;
            poseStack.m_85836_();
            var p = entry.getPose();
            var pose = poseStack.m_85850_();

            var cache = cls.getEdgeCache(entry);

            if (cache == null) {
                List<VoxelEdge> edges = new ArrayList<>();
                for (VoxelEdge edge : cls.getRenderEdges()) {
                    for (RotateAngledAxis axi : p.axis()) {
                        edge = axi.rotationEdge(edge);
                    }
                    edges.add(edge);
                }
                cache = edges.toArray(new VoxelEdge[0]);
                cls.setEdgeCache(entry, cache);
            }

            for (VoxelEdge edge : cache) {
                renderShapeEdge(pose, vertexConsumer, edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ(), x, y, z, r, g, b, a);
            }

            poseStack.m_85849_();
        }
    }


    private static void renderShapeEdge(PoseStack.Pose pose, VertexConsumer vertexConsumer, double sx, double sy, double sz, double ex, double ey, double ez, double x, double y, double z, float r, float g, float b, float a) {
        float q = (float) (ex - sx);
        float r2 = (float) (ey - sy);
        float s = (float) (ez - sz);
        float t = Mth.m_14116_(q * q + r2 * r2 + s * s);
        q /= t;
        r2 /= t;
        s /= t;
        vertexConsumer.m_252986_(pose.m_252922_(), (float) (sx + x), (float) (sy + y), (float) (sz + z)).m_85950_(r, g, b, a).m_252939_(pose.m_252943_(), q, r2, s).m_5752_();
        vertexConsumer.m_252986_(pose.m_252922_(), (float) (ex + x), (float) (ey + y), (float) (ez + z)).m_85950_(r, g, b, a).m_252939_(pose.m_252943_(), q, r2, s).m_5752_();
    }
}
