package dev.felnull.otyacraftengine.networking.existence;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockEntityExistence(ResourceLocation dimension, BlockPos blockPos, ResourceLocation blockEntityName) {
    @NotNull
    public static BlockEntityExistence read(@NotNull FriendlyByteBuf buf) {
        return new BlockEntityExistence(buf.m_130281_(), buf.m_130135_(), buf.m_130281_());
    }

    @NotNull
    public static BlockEntityExistence getByBlockEntity(@NotNull BlockEntity blockEntity) {
        var bereg = BuiltInRegistries.f_257049_.m_7981_(blockEntity.m_58903_());
        return new BlockEntityExistence(blockEntity.m_58904_().m_46472_().m_135782_(), blockEntity.m_58899_(), bereg);
    }

    public boolean check(@Nullable Level level) {
        if (level == null) return false;
        if (!level.m_46472_().m_135782_().equals(dimension))
            return false;
        var be = level.m_7702_(blockPos);
        return be != null && blockEntityName.equals(BuiltInRegistries.f_257049_.m_7981_(be.m_58903_()));
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(dimension);
        buf.m_130064_(blockPos);
        buf.m_130085_(blockEntityName);
    }
}
