/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBasedWidget;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FixedListWidget<E>
extends OEBasedWidget {
    private static final TextureRegion DEFAULT_TEXTURE = TextureRegion.relative(OE_WIDGETS, 40.0f, 34.0f, 18.0f, 42.0f);
    @NotNull
    private List<E> entryList;
    @NotNull
    private final Function<E, Component> entryName;
    @Nullable
    private final PressEntry<E> onPressEntry;
    private final boolean selectable;
    private final int entryShowCount;
    private boolean border;
    private float scrollAmount;
    private boolean canScroll;
    protected boolean isHoveredScrollBar;
    protected int hoveredNumber;
    @Nullable
    protected E selectedEntry;
    protected int selectedEntryIndex = -1;

    public FixedListWidget(int x, int y, int width, int height, @NotNull Component message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, Component> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @Nullable FixedListWidget<E> old) {
        this(x, y, width, height, message, entryShowCount, entryList, entryName, onPressEntry, selectable, DEFAULT_TEXTURE, old);
    }

    public FixedListWidget(int x, int y, int width, int height, @NotNull Component message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, Component> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @NotNull TextureRegion texture, @Nullable FixedListWidget<E> old) {
        super(x, y, width, height, "fixedListWidget", message, texture);
        this.entryShowCount = entryShowCount;
        this.entryList = entryList;
        this.entryName = entryName;
        this.onPressEntry = onPressEntry;
        this.selectable = selectable;
        this.copyValue(old);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mx, int my, float parTick) {
        if (this.f_93624_) {
            this.hoveredNumber = (my - this.m_252907_()) / this.getIndividualHeight();
            this.isHoveredScrollBar = mx >= this.m_252754_() + this.getIndividualWidth() && my >= this.m_252907_() && mx < this.m_252754_() + this.f_93618_ && my < this.m_252907_() + this.f_93619_;
        }
        super.m_88315_(guiGraphics, mx, my, parTick);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mx, int my, float parTick) {
        int cn;
        for (int i = 0; i < this.entryShowCount && (cn = this.getCurrentFirstEntryIndex() + i) < this.entryList.size() && cn >= 0; ++i) {
            E e = this.entryList.get(cn);
            this.renderOneButton(guiGraphics, e, cn, i, this.m_252754_(), this.m_252907_() + this.getIndividualHeight() * i, mx, my, parTick, this.selectedEntry == this.entryList.get(cn));
        }
        this.renderScrollbar(guiGraphics, this.m_252754_() + this.getIndividualWidth(), this.m_252907_(), 9, this.f_93619_);
    }

    protected void renderScrollbar(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        PoseStack poseStack = guiGraphics.m_280168_();
        boolean hv = this.isScrollBarHovered() || this.m_93696_();
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0(), 9.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int bsct = (this.f_93619_ - 6) / 16;
        for (int i = 0; i < bsct; ++i) {
            OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + 3 + i * 16, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 3.0f, 9.0f, 16.0f, this.getTexture().width(), this.getTexture().height());
        }
        int bsam = (this.f_93619_ - 6) % 16;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + 3 + bsct * 16, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 3.0f, 9.0f, bsam, this.getTexture().width(), this.getTexture().height());
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + this.f_93619_ - 3, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 19.0f, 9.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int barHeight = this.getBarHeight();
        float barY = (float)(this.getActualHeight() - barHeight) * this.scrollAmount;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 1) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 22.0f, 7.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; ++i) {
            OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 4 + i * 14) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 25.0f, 7.0f, 14.0f, this.getTexture().width(), this.getTexture().height());
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 4 + ssct * 14) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 25.0f, 7.0f, ssam, this.getTexture().width(), this.getTexture().height());
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 1 + barHeight - 3) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 39.0f, 7.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
    }

    protected void renderOneButton(GuiGraphics guiGraphics, E item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        guiGraphics.m_280027_(f_93617_, bX, bY, this.getIndividualWidth(), this.getIndividualHeight(), 20, 4, 200, 20, 0, this.getTextureY(this.isEntryHovered(bnum)));
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(guiGraphics, this.getMessage(lnum), k | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24, bX, bY);
    }

    public void renderString(GuiGraphics guiGraphics, Component message, int i, int x, int y) {
        this.renderScrollingString(guiGraphics, message, 2, i, x, y);
    }

    protected void renderScrollingString(GuiGraphics guiGraphics, Component message, int i, int j, int x, int y) {
        int k = x + i;
        int l = x + this.getIndividualWidth() - i;
        FixedListWidget.m_280138_((GuiGraphics)guiGraphics, (Font)FixedListWidget.mc.f_91062_, (Component)message, (int)k, (int)y, (int)l, (int)(y + this.getIndividualHeight()), (int)j);
    }

    private int getTextureY(boolean hoverd) {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (hoverd) {
            i = 2;
        }
        return 46 + i * 20;
    }

    @Override
    public void onFocusedClick() {
    }

    public void m_7435_(@NotNull SoundManager soundManager) {
        boolean nflg;
        boolean flg = this.isEntryHovered(this.hoveredNumber);
        boolean bl = nflg = this.entryList.size() > this.hoveredNumber;
        if (!flg || nflg) {
            super.m_7435_(soundManager);
        }
    }

    @Override
    public void m_5716_(double mx, double my) {
        this.onPress((int)((my - (double)this.m_252907_()) / (double)this.getIndividualHeight()));
        super.m_5716_(mx, my);
    }

    public boolean m_7979_(double mx, double my, int i, double f, double g) {
        this.scroll(my);
        return super.m_7979_(mx, my, i, f, g);
    }

    public boolean m_6375_(double mx, double my, int i) {
        this.canScroll = this.isScrollBarHovered();
        this.scroll(my);
        return super.m_6375_(mx, my, i);
    }

    public boolean m_6050_(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - this.getMouseScrollAmount(f));
        return true;
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (this.f_93623_ && this.f_93624_ && this.m_198029_()) {
            if (i == 265) {
                this.setScrollAmount(this.getScrollAmount() - 0.3f * ((float)this.entryShowCount / (float)this.f_93619_));
                return true;
            }
            if (i == 264) {
                this.setScrollAmount(this.getScrollAmount() + 0.3f * ((float)this.entryShowCount / (float)this.f_93619_));
                return true;
            }
        }
        return false;
    }

    public void onPress(int num) {
        int cn = this.getCurrentFirstEntryIndex() + num;
        if (cn < this.entryList.size() && this.isEntryHovered(num)) {
            E e = this.entryList.get(cn);
            if (this.selectable) {
                this.selectedEntry = e;
                this.selectedEntryIndex = cn;
            }
            if (this.onPressEntry != null) {
                this.onPressEntry.onPressEntry(this, e);
            }
        }
    }

    public void setSelectedEntry(int index) {
        if (index >= 0 && index < this.entryList.size()) {
            this.selectedEntry = this.entryList.get(index);
            this.selectedEntryIndex = index;
        } else {
            this.selectedEntry = null;
            this.selectedEntryIndex = -1;
        }
    }

    public void setSelectedEntry(@Nullable E selectedEntry) {
        if (selectedEntry == null || this.entryList.stream().anyMatch(n -> n == selectedEntry)) {
            this.selectedEntry = selectedEntry;
            this.selectedEntryIndex = selectedEntry == null ? -1 : this.entryList.indexOf(selectedEntry);
        }
    }

    @Nullable
    public E getSelectedEntry() {
        if (this.entryList.stream().anyMatch(n -> n == this.selectedEntry)) {
            return this.selectedEntry;
        }
        return null;
    }

    public int getSelectedEntryIndex() {
        if (this.getSelectedEntry() == null) {
            return -1;
        }
        return this.selectedEntryIndex;
    }

    protected int getCurrentFirstEntryIndex() {
        if (this.entryList.size() <= this.entryShowCount) {
            return 0;
        }
        return (int)((float)(this.entryList.size() - this.entryShowCount) * this.scrollAmount);
    }

    public boolean isEntryHovered(int lnum) {
        return this.f_93622_ && this.hoveredNumber == lnum && !this.isHoveredScrollBar;
    }

    public boolean isScrollBarHovered() {
        return this.f_93622_ && this.isHoveredScrollBar;
    }

    public Component getMessage(int index) {
        return this.entryName.apply(this.entryList.get(index));
    }

    public void scroll(double mouseY) {
        if (this.canScroll) {
            int cy = (int)(mouseY - (double)this.m_252907_() - 1.0 - (double)(this.getBarHeight() / 2));
            int sa = this.getActualHeight() - this.getBarHeight();
            if (sa > 0) {
                this.setScrollAmount((float)cy / (float)sa);
            }
        }
    }

    public int getBarHeight() {
        return Mth.m_14045_((int)((int)((float)this.getActualHeight() / ((float)this.entryList.size() / (float)this.entryShowCount))), (int)10, (int)this.getActualHeight());
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(float scrollAmount) {
        this.scrollAmount = Mth.m_14036_((float)scrollAmount, (float)0.0f, (float)1.0f);
    }

    public int getActualHeight() {
        return this.f_93619_ - 2;
    }

    public int getIndividualHeight() {
        return this.f_93619_ / this.entryShowCount;
    }

    public int getIndividualWidth() {
        return this.f_93618_ - (9 + (this.border ? 0 : 1));
    }

    @NotNull
    public List<E> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(@NotNull List<E> entryList) {
        this.entryList = entryList;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void copyValue(@Nullable FixedListWidget<E> copyValue) {
        if (copyValue != null) {
            this.selectedEntry = copyValue.selectedEntry;
            this.scrollAmount = copyValue.scrollAmount;
            this.selectedEntryIndex = copyValue.selectedEntryIndex;
        }
    }

    public float getMouseScrollAmount(double mouseAmount) {
        float am = (float)this.getIndividualHeight() / ((float)this.getIndividualHeight() * (float)Math.max(this.entryList.size() - this.entryShowCount, 1));
        float m = 1.0f;
        if (OEClientUtils.isKeyInput(FixedListWidget.mc.f_91066_.f_92090_)) {
            m *= 3.0f;
        }
        if (OEClientUtils.isKeyInput(FixedListWidget.mc.f_91066_.f_92091_)) {
            m *= 10.0f;
        }
        return (float)mouseAmount * am * m;
    }

    public static interface PressEntry<E> {
        public void onPressEntry(FixedListWidget<E> var1, E var2);
    }
}

