/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.shape;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientIVShapeLoader {
    public static final Logger LOGGER = LogManager.getLogger(ClientIVShapeLoader.class);
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, VoxelClientShape> voxelClientShapes;

    protected ClientIVShapeLoader(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        profilerFiller.m_7242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        resourceManager.m_214159_("voxel_shape", loc -> loc.m_135815_().endsWith(".json")).forEach((location, resource) -> {
            profilerFiller.m_6180_(location.toString());
            try (BufferedReader reader = resource.m_215508_();){
                JsonObject jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                String p = location.m_135815_();
                VoxelClientShape vs = VoxelClientShape.parse(jo);
                if (vs != null) {
                    builder.put((Object)new ResourceLocation(location.m_135827_(), p.substring("voxel_shape/".length(), p.length() - ".json".length())), (Object)vs);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading shape resource json " + location, (Throwable)e);
            }
            profilerFiller.m_7238_();
        });
        profilerFiller.m_7241_();
        this.voxelClientShapes = builder.build();
    }

    public Map<ResourceLocation, VoxelClientShape> getVoxelClientShapes() {
        return this.voxelClientShapes;
    }
}

