/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data.model;

import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.model.FileTexture;
import dev.felnull.otyacraftengine.data.model.ItemModelProviderAccess;
import dev.felnull.otyacraftengine.data.model.MutableFileModel;
import dev.felnull.otyacraftengine.forge.data.model.FileModelImpl;
import dev.felnull.otyacraftengine.forge.data.model.ItemMutableFileModelImpl;
import dev.felnull.otyacraftengine.forge.data.model.UncheckedTextureModelBuilder;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemModelProviderAccessImpl
implements ItemModelProviderAccess {
    private final ItemModelProvider itemModelProvider;

    public ItemModelProviderAccessImpl(ItemModelProvider itemModelProvider) {
        this.itemModelProvider = itemModelProvider;
    }

    private MutableFileModel of(ItemModelBuilder itemModelBuilder) {
        return new ItemMutableFileModelImpl(itemModelBuilder);
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull Item item) {
        return this.of(this.itemModelProvider.basicItem(item));
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull ResourceLocation itemLocation) {
        return this.of(this.itemModelProvider.basicItem(itemLocation));
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull FileTexture itemTexture) {
        ItemModelBuilder mb = (ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemTexture.getLocation().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        ResourceLocation loc = itemTexture.getLocation();
        return this.of(this.setTexture(mb, "layer0", FileTexture.of(new ResourceLocation(loc.m_135827_(), "item/" + loc.m_135815_()), itemTexture.isExistingCheck())));
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull Item item, @NotNull ResourceLocation texture) {
        return this.basicFlatItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)), texture);
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull Item item, @NotNull FileTexture itemTexture) {
        return this.basicFlatItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)), itemTexture);
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull ResourceLocation itemLocation, @NotNull ResourceLocation texture) {
        return this.of((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture));
    }

    @Override
    @NotNull
    public MutableFileModel basicFlatItem(@NotNull ResourceLocation itemLocation, @NotNull FileTexture itemTexture) {
        ItemModelBuilder mb = (ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        return this.of(this.setTexture(mb, "layer0", itemTexture));
    }

    @Override
    @NotNull
    public MutableFileModel handheldFlatItem(@NotNull Item item) {
        return this.handheldFlatItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    @Override
    @NotNull
    public MutableFileModel handheldFlatItem(@NotNull ResourceLocation itemLocation) {
        return this.of((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", new ResourceLocation(itemLocation.m_135827_(), "item/" + itemLocation.m_135815_())));
    }

    @Override
    @NotNull
    public MutableFileModel handheldFlatItem(@NotNull FileTexture itemTexture) {
        ItemModelBuilder mb = (ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemTexture.getLocation().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"));
        ResourceLocation loc = itemTexture.getLocation();
        return this.of(this.setTexture(mb, "layer0", FileTexture.of(new ResourceLocation(loc.m_135827_(), "item/" + loc.m_135815_()), itemTexture.isExistingCheck())));
    }

    @Override
    @NotNull
    public MutableFileModel parentedItem(@NotNull Item item, @NotNull ResourceLocation parentLocation) {
        return this.parentedItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)), parentLocation);
    }

    @Override
    @NotNull
    public MutableFileModel parentedItem(@NotNull ResourceLocation itemLocation, @NotNull ResourceLocation parentLocation) {
        return this.of((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.getBuilder(itemLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(parentLocation)));
    }

    @Override
    @NotNull
    public FileModel existingModel(@NotNull ResourceLocation location) {
        return new FileModelImpl((ModelFile)this.itemModelProvider.getExistingFile(location));
    }

    private ItemModelBuilder setTexture(ItemModelBuilder itemModelBuilder, String key, FileTexture fileTexture) {
        if (fileTexture.isExistingCheck()) {
            itemModelBuilder.texture(key, fileTexture.getLocation());
        } else {
            ((UncheckedTextureModelBuilder)itemModelBuilder).uncheckedTexture(key, fileTexture.getLocation());
        }
        return itemModelBuilder;
    }
}

