package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseComponent;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

public class IconButton extends Button implements OEBaseComponent {
    @NotNull
    private TextureRegion texture;

    public IconButton(int x, int y, int width, int height, Component message, OnPress onPress, @NotNull TextureRegion texture) {
        this(x, y, width, height, message, onPress, Supplier::get, texture);
    }

    public IconButton(int x, int y, int width, int height, Component message, OnPress onPress, CreateNarration createNarration, @NotNull TextureRegion texture) {
        super(x, y, width, height, message, onPress, createNarration);
        this.texture = texture;
    }

    @Override
    public @NotNull TextureRegion getTexture() {
        return texture;
    }

    @Override
    public void setTexture(@NotNull TextureRegion texture) {
        this.texture = texture;
    }

    @Override
    public @Nullable String getWidgetTypeName() {
        return "iconButton";
    }

    @Override
    public void m_87963_(PoseStack poseStack, int i, int j, float f) {
        RenderSystem.m_157456_(0, f_93617_);
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        m_275833_(poseStack, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.m_274533_());
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, 1.0F);

        renderIcon(poseStack, i, j, f);
    }

    private int m_274533_() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }

        return 46 + i * 20;
    }

    protected void renderIcon(@NotNull PoseStack poseStack, int i, int j, float f) {
        RenderSystem.m_157456_(0, getTexture().location());
        RenderSystem.m_69482_();
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, this.f_93625_);
        OERenderUtils.blitFloat(poseStack, m_252754_() + (f_93618_ - texture.uvWidth()) / 2f, m_252907_() + (f_93619_ - texture.uvHeight()) / 2f, getTexture().u0(), getTexture().v0(), getTexture().uvWidth(), getTexture().uvHeight(), getTexture().width(), getTexture().height());
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, 1.0F);
    }
}
