package dev.felnull.otyacraftengine.client.gui.components.base;

import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OEBasedButton extends AbstractButton implements OEBaseComponent {
    @Nullable
    private final String widgetTypeName;
    @NotNull
    private TextureRegion texture;

    public OEBasedButton(int x, int y, int width, int height, Component message, @Nullable String widgetTypeName, @NotNull TextureRegion texture) {
        super(x, y, width, height, message);
        this.widgetTypeName = widgetTypeName;
        this.texture = texture;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    @Override
    protected void m_168802_(NarrationElementOutput narrationElementOutput) {
        if (this.widgetTypeName == null) {
            super.m_168802_(narrationElementOutput);
            return;
        }

        narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, Component.m_237115_("narration." + widgetTypeName + ".usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, Component.m_237115_("narration." + widgetTypeName + ".usage.hovered"));
            }
        }
    }

    @Override
    protected MutableComponent m_5646_() {
        if (widgetTypeName == null)
            return super.m_5646_();
        return Component.m_237110_("gui.narrate." + widgetTypeName, m_6035_());
    }

    @Override
    public @NotNull TextureRegion getTexture() {
        return texture;
    }

    @Override
    public void setTexture(@NotNull TextureRegion texture) {
        this.texture = texture;
    }

    @Override
    public @Nullable String getWidgetTypeName() {
        return widgetTypeName;
    }
}
