package dev.felnull.otyacraftengine.item.location;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.item.location.factory.HandItemLocationFactory;
import dev.felnull.otyacraftengine.item.location.factory.PlayerItemLocationFactory;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class PlayerItemLocations {
    private static final BiMap<class_2960, PlayerItemLocationFactory<? extends PlayerItemLocation>> FACTORS = HashBiMap.create();
    public static final HandItemLocationFactory HAND_ITEM = new HandItemLocationFactory();

    public static void init() {
        register(new class_2960(OtyacraftEngine.MODID, "hand"), HAND_ITEM);
    }

    private static void register(class_2960 location, PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        FACTORS.put(location, factory);
    }

    public static class_2960 getResourceLocationByFactory(PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        return FACTORS.inverse().get(factory);
    }

    public static class_2487 saveToTag(PlayerItemLocation location) {
        var rl = location.getFactory().getLocation();
        if (rl == null)
            throw new IllegalArgumentException("Unregistered player item location");
        var tag = new class_2487();
        tag.method_10582("id", rl.toString());
        tag.method_10566("data", location.createTag());
        return tag;
    }

    public static PlayerItemLocation loadFromTag(class_2487 tag) {
        var rl = new class_2960(tag.method_10558("id"));
        var factory = FACTORS.get(rl);
        if (factory == null)
            throw new IllegalArgumentException("Unregistered player item location");

        return factory.create(tag.method_10562("data"));
    }
}
