package dev.felnull.otyacraftengine.data.provider;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.DataGeneratorType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2430;

public abstract class BlockLootTableProviderWrapper extends DataProviderWrapper<class_2405> {
    private final class_2405 blockLootTableProvider;

    public BlockLootTableProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
        this.blockLootTableProvider = crossDataGeneratorAccess.createBlockLootTableProvider(this);
    }

    @Override
    public class_2405 getProvider() {
        return blockLootTableProvider;
    }

    @Override
    public DataGeneratorType getGeneratorType() {
        return DataGeneratorType.SERVER;
    }

    public abstract void generateBlockLootTables(class_2430 blockLoot, BlockLootTableProviderAccess providerAccess);

    public abstract Iterable<class_2248> getKnownBlocks();

    protected Iterable<class_2248> extract(DeferredRegister<class_2248> deferredRegister) {
        List<class_2248> blocks = new ArrayList<>();
        deferredRegister.iterator().forEachRemaining(r -> blocks.add(r.get()));
        return blocks;
    }

    public static interface BlockLootTableProviderAccess {
        void excludeFromStrictValidation(class_2248 block);
    }
}
