package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.DataGeneratorType;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.List;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public abstract class TagProviderWrapper<T, A extends TagProviderWrapper.TagProviderAccess<T>> extends DataProviderWrapper<class_2474<T>> {
    public TagProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    public abstract void generateTag(A providerAccess);

    public static interface TagProviderAccess<T> {
        TagAppenderWrapper<T> tag(class_6862<T> tagKey);
    }

    @Override
    public DataGeneratorType getGeneratorType() {
        return DataGeneratorType.SERVER;
    }

    public static interface TagAppenderWrapper<T> {
        TagAppenderWrapper<T> add(T object);

        TagAppenderWrapper<T> add(class_5321<T>... resourceKeys);

        TagAppenderWrapper<T> addOptional(class_2960 resourceLocation);

        TagAppenderWrapper<T> addTagHolder(class_6862<T> tagKey);

        default TagAppenderWrapper<T> addTagHolder(ManualTagHolder<T> tagHolder) {
            var tp = getTagProvider();
            if (tp != null)
                tagHolder.registering(tp);
            return addTagHolder(tagHolder.getKey());
        }

        default TagAppenderWrapper<T> addVanillaTag(class_6862<T> tagKey) {
            return addTagHolder(tagKey);
        }

        TagAppenderWrapper<T> addOptionalTag(class_2960 resourceLocation);

        TagAppenderWrapper<T> add(T... objects);

        default TagAppenderWrapper<T> addTags(List<class_6862<T>> tagKeys) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (class_6862<T> tagKey : tagKeys)
                appenderWrapper = appenderWrapper.addTagHolder(tagKey);

            return appenderWrapper;
        }

        default TagAppenderWrapper<T> addTagHolders(List<ManualTagHolder<T>> tagHolders) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (ManualTagHolder<T> tagHolder : tagHolders)
                appenderWrapper = appenderWrapper.addTagHolder(tagHolder);

            return appenderWrapper;
        }

        default TagAppenderWrapper<T> addOptionalTag(class_2960... resourceLocations) {
            TagAppenderWrapper<T> appenderWrapper = this;

            for (class_2960 resourceLocation : resourceLocations)
                appenderWrapper = appenderWrapper.addOptionalTag(resourceLocation);

            return appenderWrapper;
        }

        default TagProviderAccess<T> getTagProvider() {
            return null;
        }
    }
}
