package dev.felnull.otyacraftengine.data.provider;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_7784;
import net.minecraft.class_7788;

public abstract class BlockLootTableProviderWrapper extends DataProviderWrapper<class_2405> {
    private final class_2405 blockLootTableProvider;

    public BlockLootTableProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.blockLootTableProvider = crossDataGeneratorAccess.createBlockLootTableProvider(this);
    }

    @Override
    public class_2405 getProvider() {
        return blockLootTableProvider;
    }


    public abstract void generateBlockLootTables(class_7788 blockLoot, BlockLootTableProviderAccess providerAccess);

    public abstract Iterable<class_2248> getKnownBlocks();

    protected Iterable<class_2248> extract(DeferredRegister<class_2248> deferredRegister) {
        List<class_2248> blocks = new ArrayList<>();
        deferredRegister.iterator().forEachRemaining(r -> blocks.add(r.get()));
        return blocks;
    }

    public static interface BlockLootTableProviderAccess {
        void excludeFromStrictValidation(class_2248 block);
    }
}
