/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.renderer.OERenderTypes;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import dev.felnull.otyacraftengine.explatform.client.OEClientExpectPlatform;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public final class OERenderUtils {
    private static final class_310 mc = class_310.method_1551();
    @Deprecated(forRemoval=true)
    public static boolean SKIP_TRANSANDROT_MODELPART;
    public static ThreadLocal<Boolean> SKIP_TRANSANDROT_MODELPART_V2;
    public static final float MIN_BREADTH = 0.001f;

    public static void poseTrans16(@NotNull class_4587 poseStack, double x, double y, double z) {
        float pix = 0.0625f;
        poseStack.method_22904((double)pix * x, (double)pix * y, (double)pix * z);
    }

    public static void poseScaleAll(@NotNull class_4587 poseStack, float scale) {
        poseStack.method_22905(scale, scale, scale);
    }

    public static void poseRotateAll(@NotNull class_4587 poseStack, float x, float y, float z) {
        OERenderUtils.poseRotateX(poseStack, x);
        OERenderUtils.poseRotateY(poseStack, y);
        OERenderUtils.poseRotateZ(poseStack, z);
    }

    public static void poseRotateX(@NotNull class_4587 poseStack, float angle) {
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(angle));
    }

    public static void poseRotateY(@NotNull class_4587 poseStack, float angle) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(angle));
    }

    public static void poseRotateZ(@NotNull class_4587 poseStack, float angle) {
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(angle));
    }

    public static void poseRotateHorizontalState(@NotNull class_4587 poseStack, @NotNull class_2680 state, int roted) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        OERenderUtils.poseRotateDirection(poseStack, direction, roted);
    }

    public static void poseRotateDirection(@NotNull class_4587 poseStack, @NotNull class_2350 direction, int roted) {
        for (int i = 0; i < roted; ++i) {
            direction = direction.method_10170();
        }
        if (direction == class_2350.field_11039) {
            OERenderUtils.poseRotateY(poseStack, 180.0f);
            poseStack.method_46416(-1.0f, 0.0f, -1.0f);
        } else if (direction == class_2350.field_11043) {
            OERenderUtils.poseRotateY(poseStack, 90.0f);
            poseStack.method_46416(-1.0f, 0.0f, 0.0f);
        } else if (direction == class_2350.field_11035) {
            OERenderUtils.poseRotateY(poseStack, 270.0f);
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
        }
    }

    public static void poseCenterConsumer(@NotNull class_4587 poseStack, float centerX, float centerY, float centerZ, @NotNull Consumer<class_4587> poseStackConsumer) {
        poseStack.method_46416(centerX, centerY, centerZ);
        poseStackConsumer.accept(poseStack);
        poseStack.method_46416(-centerX, -centerY, -centerZ);
    }

    public static void drawTexture(@NotNull class_2960 location, @NotNull class_4587 poseStack, float x, float y, float u0, float v0, float ru1, float rv1, float textureWidth, float textureHeight) {
        OERenderUtils.setPreDraw(location);
        OERenderUtils.blitFloat(poseStack, x, y, u0, v0, ru1, rv1, textureWidth, textureHeight);
    }

    public static void drawTexture(@NotNull class_2960 location, @NotNull class_4587 poseStack, float x, float y, float ru0, float rv0, float ru1, float rv1) {
        OERenderUtils.drawTexture(location, poseStack, x, y, ru0, rv0, ru1, rv1, 256.0f, 256.0f);
    }

    public static void setPreDraw(@NotNull class_2960 location) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setAndDrawAlpha(@NotNull class_2960 location, Runnable draw) {
        OERenderUtils.setPreDraw(location);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        draw.run();
        RenderSystem.disableBlend();
    }

    public static void drawTextureAlpha(@NotNull class_2960 location, @NotNull class_4587 poseStack, float x, float y, float u0, float v0, float ru1, float rv1, float textureWidth, float textureHeight) {
        OERenderUtils.setAndDrawAlpha(location, () -> OERenderUtils.blitFloat(poseStack, x, y, u0, v0, ru1, rv1, textureWidth, textureHeight));
    }

    public static void drawTextureAlpha(@NotNull class_2960 location, @NotNull class_4587 poseStack, float x, float y, float u0, float v0, float ru1, float rv1) {
        OERenderUtils.drawTextureAlpha(location, poseStack, x, y, u0, v0, ru1, rv1, 256.0f, 256.0f);
    }

    public static void blitFloat(@NotNull class_4587 poseStack, float x, float y, float u0, float v0, float rvu1, float rvv1, float textureWidth, float textureHeight) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float ry = x + rvu1;
        float rh = y + rvv1;
        float ru0 = u0 / textureWidth;
        float ru1 = (u0 + rvu1) / textureWidth;
        float rv0 = v0 / textureHeight;
        float rv1 = (v0 + rvv1) / textureHeight;
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x, rh, 0.0f).method_22913(ru0, rv1).method_1344();
        bufferBuilder.method_22918(matrix4f, ry, rh, 0.0f).method_22913(ru1, rv1).method_1344();
        bufferBuilder.method_22918(matrix4f, ry, y, 0.0f).method_22913(ru1, rv0).method_1344();
        bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_22913(ru0, rv0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void blitFloat(@NotNull class_4587 poseStack, float x, float y, float ru0, float rv0, float u1, float v1) {
        OERenderUtils.blitFloat(poseStack, x, y, ru0, rv0, u1, v1, 256.0f, 256.0f);
    }

    public static void drawFill(@NotNull class_4587 poseStack, float x, float y, float width, float height, int color) {
        OERenderUtils.innerFill(poseStack.method_23760().method_23761(), x, y, width, height, color);
    }

    private static void innerFill(Matrix4f matrix4f, float x, float y, float w, float h, int coler) {
        float n;
        if (x < w) {
            n = x;
            x = w;
            w = n;
        }
        if (y < h) {
            n = y;
            y = h;
            h = n;
        }
        float a = (float)(coler >> 24 & 0xFF) / 255.0f;
        float r = (float)(coler >> 16 & 0xFF) / 255.0f;
        float g = (float)(coler >> 8 & 0xFF) / 255.0f;
        float b = (float)(coler & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, x, h, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, w, h, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, w, y, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_22915(r, g, b, a).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, @NotNull class_1087 bakedModel, int combinedLight, int combinedOverlay) {
        Objects.requireNonNull(bakedModel);
        class_778 bmr = mc.method_1541().method_3350();
        bmr.method_3367(poseStack.method_23760(), vertexConsumer, null, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
    }

    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, @NotNull class_1087 bakedModel, int combinedLight, int combinedOverlay, int color) {
        Objects.requireNonNull(bakedModel);
        class_778 bmr = mc.method_1541().method_3350();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bmr.method_3367(poseStack.method_23760(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }

    @Deprecated
    public static void renderTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        OERenderUtils.poseRotateY(poseStack, yaw);
        OERenderUtils.poseRotateX(poseStack, pitch);
        OERenderUtils.poseRotateZ(poseStack, roll);
        OERenderUtils.renderTextureSprite(location, poseStack, multiBufferSource, width, height, u0, v0, u1, v1, textureWidth, textureHeight, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
    }

    public static void renderTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderSprite(poseStack, multiBufferSource.getBuffer(OERenderTypes.simpleSpriteCutout(location)), width, height, u0, v0, u1, v1, textureWidth, textureHeight, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorfulTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int color, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderColorfulSprite(poseStack, multiBufferSource.getBuffer(OERenderTypes.simpleSpriteCutout(location)), width, height, u0, v0, u1, v1, textureWidth, textureHeight, color, combinedLightIn, combinedOverlayIn);
    }

    public static void renderSprite(class_4587 poseStack, class_4588 vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderColorfulSprite(poseStack, vertexConsumer, width, height, u0, v0, u1, v1, textureWidth, textureHeight, -1, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorfulSprite(class_4587 poseStack, class_4588 vertexConsumer, float width, float height, float u0, float v0, float u1, float v1, float textureWidth, float textureHeight, int color, int combinedLightIn, int combinedOverlayIn) {
        float wst = u0 / textureWidth;
        float wft = u1 / textureWidth + wst;
        float hst = v0 / textureHeight;
        float hft = v1 / textureHeight + hst;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_4587.class_4665 pose = poseStack.method_23760();
        OERenderUtils.vertex(vertexConsumer, pose, 0.0f, 0.0f, 0.0f, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, width, 0.0f, 0.0f, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, width, height, 0.0f, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtils.vertex(vertexConsumer, pose, 0.0f, height, 0.0f, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
    }

    private static void vertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.method_22918(pose.method_23761(), x, y, z).method_22915(r, g, b, a).method_22913(u, v).method_22922(combinedOverlayIn).method_22916(combinedLightIn).method_23763(pose.method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
    }

    public static void posePlayerArm(class_4587 poseStack, class_1306 arm, float swingProgress, float equipProgress) {
        boolean bl = arm != class_1306.field_6182;
        float h = bl ? 1.0f : -1.0f;
        float j = class_3532.method_15355((float)swingProgress);
        float k = -0.3f * class_3532.method_15374((float)(j * (float)Math.PI));
        float l = 0.4f * class_3532.method_15374((float)(j * ((float)Math.PI * 2)));
        float m = -0.4f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        poseStack.method_46416(h * (k + 0.64000005f), l + -0.6f + equipProgress * -0.6f, m + -0.71999997f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(h * 45.0f));
        float n = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        float o = class_3532.method_15374((float)(j * (float)Math.PI));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(h * o * 70.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(h * n * -20.0f));
        poseStack.method_22904((double)(h * -1.0f), (double)3.6f, 3.5);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(h * 120.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(200.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(h * -135.0f));
        poseStack.method_22904((double)(h * 5.6f), 0.0, 0.0);
    }

    public static void renderPlayerArm(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, int light) {
        if (OERenderUtils.mc.field_1724.method_5767()) {
            return;
        }
        boolean bl = arm != class_1306.field_6182;
        class_1007 pr = (class_1007)mc.method_1561().method_3953((class_1297)OERenderUtils.mc.field_1724);
        RenderSystem.setShaderTexture((int)0, (class_2960)OERenderUtils.mc.field_1724.method_3117());
        if (bl) {
            pr.method_4220(poseStack, multiBufferSource, light, (class_742)OERenderUtils.mc.field_1724);
        } else {
            pr.method_4221(poseStack, multiBufferSource, light, (class_742)OERenderUtils.mc.field_1724);
        }
    }

    public static void poseHandItem(class_4587 poseStack, class_1306 arm, float swingProgress, float equipProgress) {
        boolean handFlg = arm == class_1306.field_6183;
        float s = -0.4f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
        float r = 0.2f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * ((float)Math.PI * 2)));
        float l = -0.2f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        int t = handFlg ? 1 : -1;
        poseStack.method_46416((float)t * s, r, l);
        poseStack.method_22904((double)((float)t * 0.56f), (double)(-0.52f + equipProgress * -0.6f), (double)-0.72f);
        float g = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        OERenderUtils.poseRotateY(poseStack, (float)t * (45.0f + g * -20.0f));
        float h = class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
        OERenderUtils.poseRotateZ(poseStack, (float)t * h * -20.0f);
        OERenderUtils.poseRotateX(poseStack, h * -80.0f);
        OERenderUtils.poseRotateY(poseStack, (float)t * -45.0f);
    }

    public static void renderHandItem(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, class_1799 stack, int light) {
        boolean handFlg = arm == class_1306.field_6183;
        OERenderUtils.mc.field_1773.field_4012.method_3233((class_1309)OERenderUtils.mc.field_1724, stack, handFlg ? class_809.class_811.field_4322 : class_809.class_811.field_4321, !handFlg, poseStack, multiBufferSource, light);
    }

    public static void drawCenterFont(class_4587 poseStack, class_2561 text, float x, float y, int color) {
        OERenderUtils.mc.field_1772.method_30883(poseStack, text, x - (float)OERenderUtils.mc.field_1772.method_27525((class_5348)text) / 2.0f, y, color);
    }

    public static void drawCenterFont(class_4587 poseStack, String str, float x, float y, int color) {
        OERenderUtils.mc.field_1772.method_1729(poseStack, str, x - (float)OERenderUtils.mc.field_1772.method_1727(str) / 2.0f, y, color);
    }

    public static int fontDrawInBatch(class_2561 text, float x, float y, int color, boolean shadow, Matrix4f lastPose, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        return OERenderUtils.mc.field_1772.method_30882(text, x, y, color, shadow, lastPose, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
    }

    public static int fontDrawInBatch(String text, float x, float y, int color, boolean shadow, Matrix4f lastPose, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        return OERenderUtils.mc.field_1772.method_27521(text, x, y, color, shadow, lastPose, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
    }

    @Deprecated
    public static void renderTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtils.mc.field_1772;
        Objects.requireNonNull(OERenderUtils.mc.field_1772);
        class_3272.method_30882(text, textX, (float)(-9) + textY, color, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    @Deprecated
    public static void renderTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtils.mc.field_1772;
        Objects.requireNonNull(OERenderUtils.mc.field_1772);
        class_3272.method_30882(text, textX, (float)(-9) + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    @Deprecated
    public static void renderCenterTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtils.mc.field_1772;
        float f = (float)(-OERenderUtils.mc.field_1772.method_27525((class_5348)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtils.mc.field_1772);
        class_3272.method_30882(text, f, (float)(-9) + textY, color, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    @Deprecated
    public static void renderCenterTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtils.mc.field_1772;
        float f = (float)(-OERenderUtils.mc.field_1772.method_27525((class_5348)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtils.mc.field_1772);
        class_3272.method_30882(text, f, (float)(-9) + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    public static void renderFontSprite(class_2561 text, int x, int y, int color, boolean shadow, class_4587 poseStack, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        poseStack.method_22903();
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
        poseStack.method_22909();
    }

    public static void renderFontSprite(String text, int x, int y, int color, boolean shadow, class_4587 poseStack, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        poseStack.method_22903();
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
        poseStack.method_22909();
    }

    public static void renderCenterFontSprite(class_2561 text, int x, int y, int color, boolean shadow, class_4587 poseStack, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        poseStack.method_22903();
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        x = (int)((float)x + (float)(-OERenderUtils.mc.field_1772.method_27525((class_5348)text) / 2));
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
        poseStack.method_22909();
    }

    public static void renderCenterFontSprite(String text, int x, int y, int color, boolean shadow, class_4587 poseStack, class_4597 multiBufferSource, boolean seeThrough, int bakedGlyphColor, int packedLightCoords) {
        poseStack.method_22903();
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        x = (int)((float)x + (float)(-OERenderUtils.mc.field_1772.method_1727(text) / 2));
        OERenderUtils.fontDrawInBatch(text, (float)x, (float)y, color, shadow, matrix4f, multiBufferSource, seeThrough, bakedGlyphColor, packedLightCoords);
        poseStack.method_22909();
    }

    public static void drawFixedWidthFont(class_4587 poseStack, class_2561 text, float x, float y, int color, float width) {
        int size = OERenderUtils.mc.field_1772.method_27525((class_5348)text);
        poseStack.method_22903();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtils.poseScaleAll(poseStack, scale);
        }
        OERenderUtils.mc.field_1772.method_30883(poseStack, text, x, y, color);
        poseStack.method_22909();
    }

    public static void drawFixedWidthFont(class_4587 poseStack, String text, float x, float y, int color, float width) {
        int size = OERenderUtils.mc.field_1772.method_1727(text);
        poseStack.method_22903();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtils.poseScaleAll(poseStack, scale);
        }
        OERenderUtils.mc.field_1772.method_1729(poseStack, text, x, y, color);
        poseStack.method_22909();
    }

    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y) {
        OERenderUtils.drawPlayerFace(poseStack, uuid, x, y, 8.0f);
    }

    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8.0f;
        class_2960 plskin = OETextureUtils.getPlayerSkinTexture(uuid);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.method_22909();
    }

    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y) {
        OERenderUtils.drawPlayerFace(poseStack, name, x, y, 8.0f);
    }

    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8.0f;
        class_2960 plskin = OETextureUtils.getPlayerSkinTexture(name);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtils.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.method_22909();
    }

    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, UUID uuid, float size, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderPlayerFaceSprite(poseStack, multiBufferSource.getBuffer(OERenderTypes.simpleSpriteCutout(OETextureUtils.getPlayerSkinTexture(uuid))), size, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, String name, float size, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtils.renderPlayerFaceSprite(poseStack, multiBufferSource.getBuffer(OERenderTypes.simpleSpriteCutout(OETextureUtils.getPlayerSkinTexture(name))), size, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4588 vertexConsumer, float size, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        float sc = size / 8.0f;
        OERenderUtils.renderSprite(poseStack, vertexConsumer, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 1.0E-5f);
        OERenderUtils.renderSprite(poseStack, vertexConsumer, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    public static float getPartialTicks() {
        return OEClientExpectPlatform.getPartialTicks();
    }

    public static void noTransAndRotModelPart(Runnable runnable) {
        SKIP_TRANSANDROT_MODELPART_V2.set(true);
        runnable.run();
        SKIP_TRANSANDROT_MODELPART_V2.set(false);
    }

    public static void renderPlayerArmNoTransAndRot(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, int light) {
        OERenderUtils.noTransAndRotModelPart(() -> OERenderUtils.renderPlayerArm(poseStack, multiBufferSource, arm, light));
    }

    static {
        SKIP_TRANSANDROT_MODELPART_V2 = ThreadLocal.withInitial(() -> false);
    }
}

