/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShapes;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.bundle.DirectionVoxelShapesBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.apache.commons.lang3.ArrayUtils;

public final class OEVoxelShapeUtils {
    private static final Gson GSON = new Gson();

    public static class_265 makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class_265 makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static class_265 makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 uniteBox(class_265 ... shapes) {
        return class_259.method_17786((class_265)shapes[0], (class_265[])((class_265[])ArrayUtils.remove((Object[])shapes, (int)0)));
    }

    public static class_265 uniteBox(List<class_265> shapes) {
        if (shapes.isEmpty()) {
            return class_259.method_1073();
        }
        ArrayList<class_265> shapesCp = new ArrayList<class_265>(shapes);
        class_265 voxelShape = (class_265)shapesCp.remove(0);
        class_265 shape = shapesCp.stream().reduce(voxelShape, class_259::method_1084);
        return IkisugiVoxelShapes.getInstance().unite(shape, shapes.stream().map(n -> (IkisugiVoxelShape)n).toList());
    }

    public static class_265 moveBox(class_265 shape, double x, double y, double z) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (class_238 aabb : shape.method_1090()) {
            shapes.add(class_259.method_1078((class_238)aabb.method_989(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        class_265 ushape = OEVoxelShapeUtils.uniteBox(shapes);
        return IkisugiVoxelShapes.getInstance().move(ushape, (IkisugiVoxelShape)shape, x, y, z);
    }

    public static class_265 rotateBox(class_265 shape, RotateAngledAxis angledAxis) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (class_238 aabb : shape.method_1090()) {
            shapes.add(class_259.method_1078((class_238)angledAxis.rotationAABB(aabb)));
        }
        class_265 ushape = OEVoxelShapeUtils.uniteBox(shapes);
        return IkisugiVoxelShapes.getInstance().rotate(ushape, (IkisugiVoxelShape)shape, angledAxis);
    }

    public static class_265 rotateBoxY90(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y90);
    }

    public static class_265 rotateBoxY180(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y180);
    }

    public static class_265 rotateBoxY270(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y270);
    }

    public static class_265 rotateBoxX90(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X90);
    }

    public static class_265 rotateBoxX180(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X180);
    }

    public static class_265 rotateBoxX270(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X270);
    }

    public static class_265 rotateBoxZ90(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Z90);
    }

    public static class_265 rotateBoxZ180(class_265 shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Z180);
    }

    public static class_265 rotateBoxDirection(class_265 shape, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> OEVoxelShapeUtils.rotateBoxY180(shape);
            case class_2350.field_11034 -> OEVoxelShapeUtils.rotateBoxY270(shape);
            case class_2350.field_11039 -> OEVoxelShapeUtils.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static class_265 getShapeFromResource(class_2960 location, Class<?> classLoader) {
        class_265 class_2652;
        InputStream stream = FNDataUtil.resourceExtractor(classLoader, (String)("data/" + location.method_12836() + "/voxel_shape/" + location.method_12832() + ".json"));
        if (stream == null) {
            throw new IllegalStateException("Failed to load shape: " + location);
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            class_2652 = IkisugiVoxelShapes.getInstance().getShapeFromJson((JsonObject)GSON.fromJson((Reader)reader, JsonObject.class), location);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return class_2652;
    }

    public static DirectionVoxelShapesBundle makeAllDirection(class_265 shape) {
        return new DirectionVoxelShapesBundle(shape);
    }
}

