/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.item;

import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import java.util.function.Function;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3908;
import net.minecraft.class_747;

public class ItemContainer
implements class_1263 {
    private final class_1799 itemStack;
    private final PlayerItemLocation location;
    private final class_2371<class_1799> items;
    private final String tagName;
    private final Function<class_1657, Boolean> valid;

    public ItemContainer(class_1799 itemStack, PlayerItemLocation location, int size, String tagName, Function<class_1657, Boolean> valid) {
        this.itemStack = itemStack;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.location = location;
        ItemContainer.loadItemList(itemStack, this.items, tagName);
        this.tagName = tagName;
        this.valid = valid;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int i) {
        return (class_1799)this.items.get(i);
    }

    public class_1799 method_5434(int i, int j) {
        class_1799 ret = class_1262.method_5430(this.items, (int)i, (int)j);
        this.saveItems();
        return ret;
    }

    public class_1799 method_5441(int i) {
        class_1799 ret = class_1262.method_5428(this.items, (int)i);
        this.saveItems();
        return ret;
    }

    public void method_5447(int i, class_1799 stack) {
        class_1799 itemstack = (class_1799)this.items.get(i);
        this.items.set(i, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public Function<class_1657, Boolean> getValid() {
        return this.valid;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void method_5431() {
        this.saveItems();
    }

    public boolean method_5443(class_1657 player) {
        return !this.itemStack.method_7960() && this.valid.apply(player) != false && this.location.getItem(player) == this.itemStack;
    }

    public void method_5448() {
        this.items.clear();
    }

    public void method_5432(class_1657 player) {
        super.method_5432(player);
        this.saveItems();
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public PlayerItemLocation getLocation() {
        return this.location;
    }

    public void saveItems() {
        ItemContainer.saveItemList(this.itemStack, this.items, this.tagName);
    }

    public static void loadItemList(class_1799 itemStack, class_2371<class_1799> items, String tagName) {
        class_2487 tag = itemStack.method_7969();
        if (tag != null) {
            class_1262.method_5429((class_2487)tag.method_10562(tagName), items);
        }
    }

    public static void saveItemList(class_1799 itemStack, class_2371<class_1799> items, String tagName) {
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10545(tagName)) {
            tag.method_10566(tagName, (class_2520)new class_2487());
        }
        class_1262.method_5426((class_2487)tag.method_10562(tagName), items);
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public static class_3908 createMenuProvider(class_1799 stack, PlayerItemLocation location, int size, String tagName, MenuFactory factory) {
        ItemContainer con = new ItemContainer(stack, location, size, tagName, player -> {
            if (location.getItem((class_1657)player).method_7960() || stack.method_7960()) {
                return false;
            }
            return location.getItem((class_1657)player) == stack;
        });
        return new class_747((i, inventory, player1) -> factory.createMenu(i, inventory, con, class_2338.field_10980, stack, location), stack.method_7964());
    }

    public static interface MenuFactory {
        public class_1703 createMenu(int var1, class_1661 var2, class_1263 var3, class_2338 var4, class_1799 var5, PlayerItemLocation var6);
    }
}

